% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPBkg.R
\name{Legj}
\alias{Legj}
\title{Evaluation of normalized shifted Legendre polynomials}
\description{
Evaluates the a basis of normalized shifted Legendre polynomials over a specified data vector.
}
\usage{
Legj(u, m)
}
\arguments{
\item{u}{Data vector on which the polynomials are to be evaluated.}

\item{m}{The size of the basis to be considered.}
}
\value{
Numerical values of the first \code{m} normalized shifted Legendre polynomials.
}

\examples{
x<-rnorm(1000,10,7)
xx<-x[x>=10 & x<=20]
G<-pnorm(20,5,15)-pnorm(10,5,15)
g<-function(x){dnorm(x,5,15)/G}
g<-Vectorize(g)
u<-g(xx)
Mmax=20
s<-as.matrix(Legj(u,Mmax))
}
\keyword{Normalized shifted Legendre polynomials.}
