% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_EFTs_custering.R
\name{EFT_clust}
\alias{EFT_clust}
\title{EFT_clust}
\usage{
EFT_clust(obj2clust = NULL, n_clust = 20, filename = "", ...)
}
\arguments{
\item{obj2clust}{RasterStack or RasterBrick object (or its file name). Each layer is one variable}

\item{n_clust}{Numeric. Number of total clusters. Optional. Default = 20}

\item{filename}{Character. Output filename. Optional}

\item{...}{Arguments for \code{\link[stats]{kmeans}}. Optional}
}
\value{
A list with two components: (1) a RasterLayer object with the clusters and (2) a vector with the clustering evaluation in percentage
}
\description{
EFT_clust derives the Ecosystem Functional Types using K-means to perform a clustering on the
pixels of the Raster* object
}
\details{
\code{\link[stats]{kmeans}} does not optimize the final number of clusters. It needs to be set by means of 'n_clust'
(default = 20). There are several methods and statistics to determine the optimal number. \code{\link{clust_optim}}
produces a scree plot to help the user to decide the optimal number of clusters.

EFT_clust passes as default to \code{\link[stats]{kmeans}} iter.max = 500 and algorithm = "MacQueen", but these can be
modified passing these arguments through '...'

An evaluation of the clustering is provided together with the RasterLayer object.
It is calculated as model$betweenss / model$totss * 100;
where 'betweenss' and 'totss' are generated by \code{\link[stats]{kmeans}}
}
\examples{
\donttest{
dirctry <- paste0(system.file(package='LPDynR'), "/extdata")
variables_noCor <- rm_multicol(dir2process = dirctry,
                               multicol_cutoff = 0.7)
EFT_clust(obj2clust = variables_noCor,
         n_clust = 10)
}
}
\seealso{
\code{\link{PCAs4clust}}; \code{\link{clust_optim}}; \code{\link[stats]{kmeans}}
}
\author{
Xavier Rotllan-Puig
}
