% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_tests.R
\name{gaussian_variance_lr_test}
\alias{gaussian_variance_lr_test}
\title{Test the variance of a gaussian distribution using the likelihood ratio test.}
\source{
\url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
}
\usage{
gaussian_variance_lr_test(
  x,
  sigma.squared,
  alternative = "two.sided",
  conf.level = 0.95
)
}
\arguments{
\item{x}{a numeric vector of at least 50 data values.}

\item{sigma.squared}{a number indicating the tested value of sigma squared.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test the variance of a gaussian distribution using the likelihood ratio test.
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rnorm(100, 0, 1)
gaussian_variance_lr_test(x, 1, "two.sided")

# Null is false
set.seed(1)
x <- rnorm(100, 0, 2)
gaussian_variance_lr_test(x, 1, "greater")
}
