% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST.R
\name{MWA}
\alias{MWA}
\title{Mono window algorithm}
\usage{
MWA(BT = BT, tau = tau, E = E, Ta = Ta)
}
\arguments{
\item{BT}{Raster* object, brightness temperature}

\item{tau}{Atmospheric transmittance}

\item{E}{Raster* object, Land Surface Emissivity calculated according to Van de Griend and Owe 1993 or Valor and Caselles 1996 or Sobrino et al. 2008}

\item{Ta}{Mean atmospheric temperature (K) of the date when Landsat passed over the study area}
}
\value{
RasterLayer
}
\description{
This function calculates Land Surface Temperature using mono window algorithm
}
\examples{
BTemp <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(BTemp) = runif(10000, min=298, max=305)
E <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(E) = runif(10000, min=0.96, max=0.99)
MWA(BT = BTemp, tau = 0.86, E = E, Ta = 26)
}
