% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LWestimate.R
\name{LWestimate}
\alias{LWestimate}
\title{Generate Litchfield and Wilcoxon Estimates}
\usage{
LWestimate(estParams, DEdata)
}
\arguments{
\item{estParams}{A numeric vector of length 2, the estimated parameters (intercept and
slope) of a straight line on the log10-probit scale, typically output
from \code{\link{fitLWauto}}.}

\item{DEdata}{A data frame of dose-effect data (typically, the output from
\code{\link{dataprep}}) containing at least eight variables:
dose, ntot, nfx, pfx, log10dose, bitpfx, fxcateg, and LWkeep
(see Details).}
}
\value{
A list of length three:
  \itemize{
    \item \code{chi} = the chi-squared statistic with associated P value and
      degrees of freedom,
    \item \code{params} = the estimated intercept and slope of the
      dose-response curve on the log10 probit scale,
    \item \code{LWest} = the Litchfield Wilcoxon estimates of
      ED50 with 95\% confidence intervals and the number of records with
      partial effects (npartfx) as well as other metrics used in their
      step-by-step approach
      (ED16, ED84, S with 95\% confidence intervals, N', and fED50).
  }
}
\description{
Generate Litchfield and Wilcoxon's (1949) estimates in the evaluation of
  dose-effect experiments.
}
\details{
The input data are expected to be summarized by dose.
  If duplicate doses are provided, an error will be thrown.
}
\examples{
dose <- c(0.0625, 0.125, 0.25, 0.5, 1)
ntested <- rep(8, 5)
nalive <- c(1, 4, 4, 7, 8)
mydat <- dataprep(dose=dose, ntot=ntested, nfx=nalive)
mydat
intslope <- fitLWauto(mydat)
LWestimate(intslope, mydat)
}
\references{
Litchfield, JT Jr. and F Wilcoxon.  1949.
    A simplified method of evaluating dose-effect experiments.
    Journal of Pharmacology and Experimental Therapeutics 96(2):99-113.
    \href{http://jpet.aspetjournals.org/content/96/2/99.abstract}{[link]}.
}

