% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/k.read.R
\name{k.read.base}
\alias{k.cole.base}
\alias{k.crusius.base}
\alias{k.heiskanen.base}
\alias{k.macIntyre.base}
\alias{k.read.base}
\alias{k.read.soloviev.base}
\alias{k.vachon.base}
\title{Returns a timeseries of gas exchange velocity}
\usage{
k.cole.base(wnd)

k.crusius.base(wnd, method='power')

k.read.base(wnd.z, Kd, lat, lake.area, atm.press, dateTime, Ts, z.aml,
airT, wnd, RH, sw, lwnet)

k.read.soloviev.base(wnd.z, Kd, lat, lake.area, atm.press, dateTime, Ts, z.aml,
airT, wnd, RH, sw, lwnet)

k.macIntyre.base(wnd.z, Kd, atm.press, dateTime, Ts, z.aml, airT, wnd, RH, sw,
lwnet, params=c(1.2,0.4872,1.4784))

k.vachon.base(wnd, lake.area, params=c(2.51,1.48,0.39))

k.heiskanen.base(wnd.z, Kd, atm.press, dateTime, Ts, z.aml, airT, wnd, RH, sw, lwnet)
}
\arguments{
\item{wnd.z}{Height of wind measurement, (Units: m)}

\item{Kd}{Light attenuation coefficient (Units: m^-1)}

\item{lat}{Latitude, degrees north}

\item{lake.area}{Lake area, m^2}

\item{atm.press}{Atmospheric pressure, (Units: millibar)}

\item{dateTime}{datetime (Y-\%m-\%d \%H:\%M), (Format: \code{\link{POSIXct}})}

\item{Ts}{Numeric vector of surface water temperature, (Units(deg C)}

\item{z.aml}{Numeric vector of actively mixed layer depths. Must be the same length as the Ts parameter}

\item{airT}{Numeric value of air temperature, Units(deg C)}

\item{wnd}{Numeric value of wind speed, (Units:m/s)}

\item{RH}{Numeric value of relative humidity, \%}

\item{sw}{Numeric value of short wave radiation, W m^-2}

\item{lwnet}{Numeric value net long wave radiation, W m^-2}

\item{method}{Only for \link{k.crusius.base}. String of valid method . Either "constant", "bilinear", or "power"}

\item{params}{Optional parameter input, only for \link{k.vachon.base} and \link{k.macIntyre.base}. See details.}
}
\value{
Numeric value of gas exchange velocity (k600) in units of m/day. Before use,
should be converted to appropriate gas using \link{k600.2.kGAS}.
}
\description{
Returns the gas exchange velocity based on the chosen model in units of m/day
}
\details{
Can change default parameters of MacIntyre and Vachon models. Default for Vachon is
c(2.51,1.48,0.39). Default for MacIntyre is c(1.2,0.4872,1.4784). Heiskanen et al. (2014) uses MacIntyre
model with c(0.5,0.77,0.3) and z.aml constant at 0.15.
}
\examples{
wnd.z <- 2
Kd <- 2
lat <- 54
lake.area <- 5000
atm.press <- 1013
dateTime <- as.POSIXct("2013-12-30 14:00")
Ts <- 16.5
z.aml <- 2.32
airT <- 20
wnd <- 6
RH <- 90
sw <- 800
lwnet <- -55
timeStep <- 30

U10 <- wind.scale.base(wnd, wnd.z)

k600_cole <- k.cole.base(U10)

k600_crusius <- k.crusius.base(U10)

k600_read <- k.read.base(wnd.z, Kd, lat, lake.area, atm.press,
dateTime, Ts, z.aml, airT, wnd, RH, sw, lwnet)

k600_soloviev <- k.read.soloviev.base(wnd.z, Kd, lat, lake.area,
atm.press, dateTime, Ts, z.aml, airT, wnd, RH, sw, lwnet)

k600_macInytre <- k.macIntyre.base(wnd.z, Kd, atm.press,
dateTime, Ts, z.aml, airT, wnd, RH, sw, lwnet)
}
\author{
R. Iestyn. Woolway, Hilary Dugan, Luke Winslow, Jordan S Read, GLEON fellows
}
\references{
Cole, J., J. Nina, and F. Caraco. \emph{Atmospheric exchange of carbon dioxide
in a low-wind oligotrophic lake measured by the addition of SF~ 6}.
Limnology and Oceanography 43 (1998): 647-656.

MacIntyre, Sally, Anders Jonsson, Mats Jansson, Jan Aberg, Damon E. Turney,
and Scott D. Miller. \emph{Buoyancy flux, turbulence, and the gas transfer
coefficient in a stratified lake}. Geophysical Research Letters 37, no. 24 (2010).

Read, Jordan S., David P. Hamilton, Ankur R. Desai, Kevin C. Rose, Sally MacIntyre,
John D. Lenters, Robyn L. Smyth et al. \emph{Lake-size dependency of wind shear and convection
as controls on gas exchange}. Geophysical Research Letters 39, no. 9 (2012).

Crusius, John, and Rik Wanninkhof. \emph{Gas transfer velocities measured at low
wind speed over a lake}. Limnology and Oceanography 48, no. 3 (2003): 1010-1017.

Dominic Vachon and Yves T. Prairie. \emph{The ecosystem size and shape dependence
of gas transfer velocity versus wind speed relationships in lakes}.
Can. J. Fish. Aquat. Sci. 70 (2013): 1757-1764.

Jouni J. Heiskanen, Ivan Mammarella, Sami Haapanala, Jukka Pumpanen, Timo Vesala, Sally MacIntyre
Anne Ojala.\emph{ Effects of cooling and internal wave motions on gas
transfer coefficients in a boreal lake}. Tellus B 66, no.22827 (2014)

Alexander Soloviev, Mark Donelan, Hans Graber, Brian Haus, Peter Schlussel.
\emph{An approach to estimation of near-surface turbulence and CO2 transfer
velocity from remote sensing data}. Journal of Marine Systems 66, (2007): 182-194.
}
\seealso{
\link{k.cole}
\link{k.read}
\link{k.crusius}
\link{k.macIntyre}
\link{k.vachon}
\link{k.heiskanen}
}
\keyword{math}
\keyword{methods}

