% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sun.rise.set.R
\name{sun.rise.set}
\alias{sun.rise.set}
\title{Calculates the time of sunrise and sunset}
\usage{
sun.rise.set(datetimes, lat)
}
\arguments{
\item{datetimes}{Vector of dates as \code{POSIXct} or \code{POSIXlt} (see \code{\link{DateTimeClasses}}) format}

\item{lat}{Single latitude value of site. South should be negative, north positive}
}
\value{
A 2-column matrix, first column sunrise, second column sunset, as \link{POSIXct} format.
Value is NA when there is no defined sunrise or sunset for that day (winter/summer at high and low latitudes).
}
\description{
Calculates the time of sunrise and sunset based on latitude and date.
}
\examples{
sun.rise.set(lat=40.75,datetimes=as.POSIXlt('2013-03-31'))
}
\author{
Luke A. Winslow
}
\references{
Iqbal, Muhammad. 1983. An Introduction to Solar Radiation. Elsevier.
}
\seealso{
\link{is.night}
\link{is.day}
}
\keyword{methods}

