% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/0_LambertW_input_output-methods.R, R/plot.LambertW_input.R, R/plot.LambertW_output.R, R/print.LambertW_input.R, R/print.LambertW_output.R
\name{LambertW_input_output-methods}
\alias{LambertW_input_output-methods}
\alias{plot.LambertW_input}
\alias{plot.LambertW_output}
\alias{print.LambertW_input}
\alias{print.LambertW_output}
\title{Methods for Lambert W input and output objects}
\usage{
\method{plot}{LambertW_input}(x, xlim = NULL, ...)

\method{plot}{LambertW_output}(x, xlim = NULL, ...)

\method{print}{LambertW_input}(x, ...)

\method{print}{LambertW_output}(x, ...)
}
\arguments{
\item{x}{object of class \code{LambertW_input} or \code{LambertW_output}.}

\item{xlim}{lower and upper limit of x-axis for cdf and pdf plots. If \code{NULL},
it tries to determine good limits based on the family type of the distribution
and the quantiles.  Most of the times it will show the pdf and cdf from the 0.5\% to
99.5\% quantile.}

\item{\dots}{further arguments passed to or from other methods.}
}
\description{
S3 methods for Lambert W input and output objects
(created by \code{\link{create_LambertW_input}} and \code{\link{create_LambertW_output}}).

\code{plot.LambertW_input} plots the theoretical (1) pdf and (2) cdf of the
input \eqn{X \sim F_X(x \mid \boldsymbol \beta)}.

\code{plot.LambertW_output} plots the theoretical (1) pdf and (2) cdf of the
output RV \eqn{Y \sim} Lambert W \eqn{\times} \eqn{F_X(x \mid \boldsymbol
\beta)}. It overlays the plot with the pdf and cdf of the input RV \eqn{X \sim F_X(x \mid
\boldsymbol \beta)} (setting \eqn{\gamma = \delta = 0, \alpha = 1}).

\code{print.LambertW_input} prints an overview of the output object.

\code{print.LambertW_output} prints an overview of the output object.
}
\examples{
# create a Normal(1, 2) input
Gauss.input <- create_LambertW_input("normal", beta = c(1, 2))
plot(Gauss.input)
# make it a bit heavy tailed (beta in theta comes from Gauss.input)
LW.Gauss <- create_LambertW_output(LambertW.input = Gauss.input,
                                   theta = list(delta = c(0.3)))
LW.Gauss  # print a nice overview in the console
plot(LW.Gauss)

# draw random sample
LW.Gauss$r(n=10)
Gauss.input$r(n=10)
# quantiles
LW.Gauss$q(p=0.6)
Gauss.input$q(p=0.6)
}
\keyword{hplot}
\keyword{print}

