% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LagLaplaceDeconvolution.R
\name{BuildLaguerreSystem}
\alias{BuildLaguerreSystem}
\title{function BuildLaguerreSystem}
\usage{
BuildLaguerreSystem(a, g, times, Mmax, tol = 1e-07)
}
\arguments{
\item{a, }{numeric, the scale parameter of the Laguerre functions basis}

\item{g, }{numeric vector, the observed values of the known Laplace convolution kernel at the observation times}

\item{times, }{numeric vector, the observation times}

\item{Mmax, }{numeric, the maximal degree}

\item{tol, }{tolerance in qr decomposition (default 1e-7)}
}
\value{
a list containing:
\itemize{
\item \code{gcoef}, numeric vector, the coefficients of g in the Laguerre functions basis
\item \code{GM}, numeric matrix, the Toeplitz matrix of the Laplace convolution with g
\item \code{Phi}, numeric matrix, the Laguerre function basis
\item \code{Phi.qr}, the QR decomposition of Phi
\item \code{Mmax}, numeric, the maximal degree
\item \code{a}, numeric, the scale of the Laguerre function basis
\item \code{g}, numeric vector, the kernel
\item \code{times}, numeric vector, the observation times
}
}
\description{
build the matrix associated to the Laguerre function basis at given times, its QR decomposition, the coefficients of the kernel function of the Laplace convolution and the Toeplitz matrix associated to the Laplace convolution with the kernel g.
}
\examples{
 \dontrun{

 library(LaplaceDeconv)
 t = seq(0,10,l=50)
 g = exp(-5*t)
 # compute the elements needed for the Laplace deconvolution with kernel observations g at times t
 bFctLagMat = BuildLaguerreSystem(a=1/2,g,t,M=10)
 }
}
\author{
Y. Rozenholc and M. Pensky
}

