% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChiSquare.R
\name{ChiSquare}
\alias{ChiSquare}
\alias{table.chisq}
\title{Chi-Square Test on Contingency Table}
\description{
Performs chi-square test on contingency tables.
}
\examples{
t <- pmt(
    "table.chisq", n_permu = 0
)$test(Table5.4.2)$print()

t$type <- "asymp"
t

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:ContingencyTableTest]{LearnNonparam::ContingencyTableTest}} -> \code{ChiSquare}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ChiSquare-new}{\code{ChiSquare$new()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="plot"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-plot'><code>LearnNonparam::PermuTest$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChiSquare-new"></a>}}
\if{latex}{\out{\hypertarget{method-ChiSquare-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{ChiSquare} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChiSquare$new(type = c("permu", "asymp"), n_permu = 10000)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{a character string specifying the way to calculate the p-value.}

\item{\code{n_permu}}{an integer indicating number of permutations for the permutation distribution. If set to zero (default) then all permutations are used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{ChiSquare} object.
}
}
}
