% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wilcoxon.R
\name{Wilcoxon}
\alias{Wilcoxon}
\alias{twosample.wilcoxon}
\title{Two-Sample Wilcoxon Test}
\description{
Performs two-sample wilcoxon test on samples. In addition, an estimation and a confidence interval for the location shift will be calculated.
}
\examples{
pmt(
    "twosample.wilcoxon",
    alternative = "greater", n_permu = 0
)$test(Table2.1.1)$print()

pmt(
    "twosample.wilcoxon",
    alternative = "less", n_permu = 0
)$test(Table2.6.1)$print()

pmt(
    "twosample.wilcoxon", conf_level = 0.90
)$test(Table2.6.2)$conf_int

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:TwoSampleTest]{LearnNonparam::TwoSampleTest}} -> \code{\link[LearnNonparam:TwoSampleLocationTest]{LearnNonparam::TwoSampleLocationTest}} -> \code{Wilcoxon}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{correct}}{Whether to apply continuity correction.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Wilcoxon-new}{\code{Wilcoxon$new()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="plot"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-plot'><code>LearnNonparam::PermuTest$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Wilcoxon-new"></a>}}
\if{latex}{\out{\hypertarget{method-Wilcoxon-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Wilcoxon} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Wilcoxon$new(
  type = c("permu", "asymp"),
  alternative = c("two_sided", "less", "greater"),
  null_value = 0,
  conf_level = 0.95,
  n_permu = 10000,
  correct = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{a character string specifying the way to calculate the p-value.}

\item{\code{alternative}}{a character string specifying the alternative hypothesis.}

\item{\code{null_value}}{a number indicating the true value of the location shift.}

\item{\code{conf_level}}{a number between zero and one indicating the confidence level to use.}

\item{\code{n_permu}}{an integer indicating number of permutations for the permutation distribution. If set to zero (default) then all permutations are used.}

\item{\code{correct}}{a logical indicating whether to apply continuity correction in the normal approximation for the p-value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Wilcoxon} object.
}
}
}
