% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_LL.R
\docType{data}
\name{import_Dataset}
\alias{import_Dataset}
\alias{import}
\title{Import a light logger dataset or related data}
\format{
An object of class \code{list} of length 10.
}
\usage{
import_Dataset(device, ...)

import
}
\arguments{
\item{device}{From what device do you want to import? For a few devices,
there is a sample data file that you can use to test the function (see the
examples). See \link{supported.devices} for a list of supported devices and see
below for more information on devices with specific requirements.}

\item{...}{Parameters that get handed down to the specific import functions}
}
\value{
Tibble/Dataframe with a POSIXct column for the datetime
}
\description{
Imports a dataset and does the necessary transformations to get the right
column formats. Unless specified otherwise, the function will set the
timezone of the data to \code{UTC}. It will also enforce an \code{Id} to separate
different datasets and will order/arrange the dataset within each \code{Id} by
Datetime. See the Details and Devices section for more information and the
full list of arguments.
}
\details{
There are specific and a general import function. The general import function
is described below, whereas the specific import functions take the form of
\code{import$device()}. The general import function is a thin wrapper around the
specific import functions. The specific import functions take the following
arguments:
\itemize{
\item \code{filename}: Filename(s) for the Dataset. Can also contain the filepath,
but \code{path} must then be \code{NULL}. Expects a \code{character}. If the vector is
longer than \code{1}, multiple files will be read in into one Tibble.
\item \code{path}: Optional path for the dataset(s). \code{NULL} is the default. Expects
a \code{character}.
\item \code{n_max}: maximum number of lines to read. Default is \code{Inf}.
\item \code{tz}: Timezone of the data. \code{"UTC"} is the default. Expects a
\code{character}. You can look up the supported timezones with \code{\link[=OlsonNames]{OlsonNames()}}.
\item \code{Id.colname}: Lets you specify a column for the id of a dataset. Expects a
symbol (Default is \code{Id}). This column will be used for grouping
(\code{\link[dplyr:group_by]{dplyr::group_by()}}).
\item \code{auto.id}: If the \code{Id.colname} column is not part of the \code{dataset}, the \code{Id}
can be automatically extracted from the filename. The argument expects a
regular expression \link{regex} and will by default just give the whole filename
without file extension.
\item \code{manual.id}: If this argument is not \code{NULL}, and no \code{Id} column is part
of the \code{dataset}, this \code{character} scalar will be used. \strong{We discourage the
use of this arguments when importing more than one file}
\item \code{locale}: The locale controls defaults that vary from place to place.
\item \code{dst_adjustment}: If a file crosses daylight savings time, but the device does not adjust time stamps accordingly, you can set this argument to \code{TRUE}, to apply this shift manually. It is selective, so it will only be done in files that cross between DST and standard time. Default is \code{FALSE}. Uses \code{dst_change_handler()} to do the adjustment. Look there for more infos. It is not equipped to handle two jumps in one file (so back and forth between DST and standard time), but will work fine if jums occur in separate files.
\item \code{auto.plot}: a logical on whether to call \code{\link[=gg_overview]{gg_overview()}} after import. Default is \code{TRUE}.
\item \code{...}: supply additional arguments to the \pkg{readr} import functions, like \code{na}. Might also be used to supply arguments to the specific import functions, like \code{column_names} for \code{Actiwatch_Spectrum} devices. Those devices will always throw a helpful error message if you forget to supply the necessary arguments.
If the \code{Id} column is already part of the \code{dataset} it will just use
this column. If the column is not present it will add this column and fill
it with the filename of the importfile (see param \code{auto.id}).
\code{print_n} can be used if you want to see more rows from the observation intervals
}
}
\section{Devices}{

The set of import functions provide a convenient way to import light logger
data that is then perfectly formatted to add metadata, make visualizations
and analyses. There are a number of devices supported, where import should
just work out of the box. To get an overview, you can simply call the
\code{supported.devices} dataset. The list will grow continuously as the package
is maintained.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{supported.devices
#>  [1] "Actiwatch_Spectrum" "ActLumus"           "ActTrust"          
#>  [4] "DeLux"              "LiDo"               "LightWatcher"      
#>  [7] "LYS"                "nanoLambda"         "Speccy"            
#> [10] "SpectraWear"
}\if{html}{\out{</div>}}
\subsection{ActLumus}{

Manufacturer: Condor Instruments
Model: ActLumus
Implemented: 2023
A sample file is provided with the package, it can be accessed through
\code{system.file("extdata/205_actlumus_Log_1020_20230904101707532.txt.zip", package = "LightLogR")}. It does not need to be unzipped to be imported.
This sample file is a good example for a regular dataset without gaps
}

\subsection{LYS}{

Manufacturer: LYS Technologies
Model: LYS Button
Implemented: 2023
A sample file is provided with the package, it can be accessed
through \code{system.file("extdata/sample_data_LYS.csv", package = "LightLogR")}. This sample file is a good example for an irregular dataset.
}

\subsection{Actiwatch_Spectrum}{

Manufacturer: Philips Respironics
Model: Actiwatch Spectrum
Implemented: 2023
\strong{Required Argument: \code{column_names}} A character vector containing column
names in the order in which they appear in the file. This is necessary to
find the starting point of actual data.
}

\subsection{ActTrust}{

Manufacturer: Condor Instruments
Model: ActTrust1, ActTrust2
Implemented: 2024
This function works for both ActTrust 1 and 2 devices
}

\subsection{Speccy}{

Manufacturer: Monash University
Model: Speccy
Implemented: 2024
}

\subsection{DeLux}{

Manufacturer: Intelligent Automation Inc
Model: DeLux
Implemented: 2023
}

\subsection{LiDo}{

Manufacturer: University of Lucerne
Model: LiDo
Implemented: 2023
}

\subsection{SpectraWear}{

Manufacturer:
Model: SpectraWear
Implemented: 2024
}

\subsection{NanoLambda}{

Manufacturer: NanoLambda
Model: XL-500 BLE
Implemented: 2024
}

\subsection{LightWatcher}{

Manufacturer: Object-Tracker
Model: LightWatcher
Implemented: 2024
}
}

\section{Examples}{

\subsection{Imports made easy}{

To import a file, simple specify the filename (and path) and feed it to the
\code{import_Dataset} function. There are sample datasets for all devices.

The import functions provide a basic overview of the data after import,
such as the intervals between measurements or the start and end dates.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{filepath <- system.file("extdata/sample_data_LYS.csv", package = "LightLogR")
dataset <- import_Dataset("LYS", filepath, auto.plot = FALSE)
#> 
#> Successfully read in 11'422 observations across 1 Ids from 1 LYS-file(s).
#> Timezone set is UTC.
#> The system timezone is Europe/Berlin. Please correct if necessary!
#> 
#> First Observation: 2023-06-21 00:00:12
#> Last Observation: 2023-06-22 23:59:48
#> Timespan: 2 days
#> 
#> Observation intervals: 
#>   Id              interval.time     n pct    
#> 1 sample_data_LYS 15s           10015 87.689\%
#> 2 sample_data_LYS 16s            1367 11.969\%
#> 3 sample_data_LYS 17s              23 0.201\% 
#> 4 sample_data_LYS 18s              16 0.140\%
}\if{html}{\out{</div>}}

Import functions can also be called directly:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{filepath <- system.file("extdata/205_actlumus_Log_1020_20230904101707532.txt.zip", package = "LightLogR")
dataset <- import$ActLumus(filepath, auto.plot = FALSE)
#> 
#> Successfully read in 61'016 observations across 1 Ids from 1 ActLumus-file(s).
#> Timezone set is UTC.
#> The system timezone is Europe/Berlin. Please correct if necessary!
#> 
#> First Observation: 2023-08-28 08:47:54
#> Last Observation: 2023-09-04 10:17:04
#> Timespan: 7.1 days
#> 
#> Observation intervals: 
#>   Id                                          interval.time     n pct  
#> 1 205_actlumus_Log_1020_20230904101707532.txt 10s           61015 100\%
dataset \%>\% gg_days()
}\if{html}{\out{</div>}}

\figure{unnamed-chunk-1-1.png}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dataset \%>\%
dplyr::select(Datetime, TEMPERATURE, LIGHT, MEDI, Id) \%>\%
dplyr::slice(1500:1505)
#> # A tibble: 6 x 5
#> # Groups:   Id [1]
#>   Datetime            TEMPERATURE LIGHT  MEDI Id                                
#>   <dttm>                    <dbl> <dbl> <dbl> <fct>                             
#> 1 2023-08-28 12:57:44        26.9  212.  202. 205_actlumus_Log_1020_20230904101~
#> 2 2023-08-28 12:57:54        26.9  208.  199. 205_actlumus_Log_1020_20230904101~
#> 3 2023-08-28 12:58:04        26.9  205.  196. 205_actlumus_Log_1020_20230904101~
#> 4 2023-08-28 12:58:14        26.8  204.  194. 205_actlumus_Log_1020_20230904101~
#> 5 2023-08-28 12:58:24        26.9  203.  194. 205_actlumus_Log_1020_20230904101~
#> 6 2023-08-28 12:58:34        26.8  204.  195. 205_actlumus_Log_1020_20230904101~
}\if{html}{\out{</div>}}
}
}

\seealso{
\link{supported.devices}
}
\keyword{datasets}
