% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinearDetect-package.R
\name{var.first.step.blocks}
\alias{var.first.step.blocks}
\title{Threshold block fused lasso step for linear regression model.}
\usage{
var.first.step.blocks(
  data_y,
  lambda1,
  lambda2,
  q,
  max.iteration,
  tol,
  blocks,
  cv.index,
  HBIC = FALSE,
  gamma.val = NULL
)
}
\arguments{
\item{data_y}{input data matrix Y, with each column representing the time series component}

\item{lambda1}{tuning parmaeter lambda_1 for fused lasso}

\item{lambda2}{tuning parmaeter lambda_2 for fused lasso}

\item{q}{the AR order}

\item{max.iteration}{max number of iteration for the fused lasso}

\item{tol}{tolerance for the fused lasso}

\item{blocks}{the blocks}

\item{cv.index}{the index of time points for cross-validation}

\item{HBIC}{logical; if TRUE, use high-dimensional BIC, if FALSE, use orginal BIC. Default is FALSE.}

\item{gamma.val}{hyperparameter for HBIC, if HBIC == TRUE.}
}
\value{
A list object, which contains the followings
\describe{
  \item{jump.l2}{estimated jump size in L2 norm}
  \item{jump.l1}{estimated jump size in L1 norm}
  \item{pts.list}{estimated change points in the first step}
  \item{phi.full}{estimated parameters in the first step}
}
}
\description{
Perform the block fused lasso with thresholding to detect candidate break points.
}
