% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LncFinder.R
\name{svm_tune}
\alias{svm_tune}
\title{Parameter Tuning of SVM}
\usage{
svm_tune(dataset, label.col = 1, positive.class = "NonCoding",
  folds.num = 10, seed = 1, gamma.range = (2^seq(-5, 0, 1)),
  cost.range = c(1, 4, 8, 16, 24, 32), return.model = TRUE,
  parallel.cores = 2)
}
\arguments{
\item{dataset}{The dataset obtained from function \code{\link{extract_features}}.
Or datasets used to build the classifier.}

\item{label.col}{integer specifying the column number of the label. (Default: \code{1})}

\item{positive.class}{Character. Indicate the positive class of the dataset.
(Default: \code{NonCoding}) The value of this parameter should be identical to
one of the classes of the response vectors.}

\item{folds.num}{Integer. Specify the number of folds for cross-validation.
(Default: \code{10})}

\item{seed}{Integer. Used to set the seed for cross-validation. (Default: \code{1})}

\item{gamma.range}{The range of gamma. (Default: \code{2 ^ seq(-5, 0, 1)})}

\item{cost.range}{The range of cost. (Default: \code{c(1, 4, 8, 16, 24, 32)})}

\item{return.model}{Logical. If \code{TRUE}, the function will return the best
model trained on the full dataset. If \code{FALSE}, this function will return
the optimal parameters.}

\item{parallel.cores}{Integer. The number of cores for parallel computation.
By default the number of cores is \code{2}, users can set as \code{-1} to run
this function with all cores. If the number of \code{parallel.cores} is more
than the \code{folds.num} (number of the folds for cross-validation), the
number of \code{parallel.cores} will be set as \code{folds.num} automatically.}
}
\value{
Returns the optimal parameters when \code{return.model = FALSE}.#'
Or returns the best model when \code{return.model = TRUE}.
}
\description{
This function conduct the parameter tuning of SVM. Parameters
gamma and cost can be tuned using grid search.
}
\details{
During the model tuning, the performance of each combination of
parameters will output. Sensitivity, Specificity, Accuracy, F-Measure and Kappa
Value are used to evaluate the performances. The best gamma and cost (or best
model) are selected based on Accuracy.

For the details of parameter gamma and cost, please refer to function
\code{\link[e1071]{svm}} of package "e1071".

For the details of metrics, please refer to function
\code{\link[caret]{confusionMatrix}} of package "caret".
}
\examples{
\dontrun{
data(demo_DNA.seq)
Seqs <- demo_DNA.seq

positive_data <- extract_features(Seqs[1:5], label = "NonCoding",
                                  SS.features = FALSE, format = "DNA",
                                  frequencies.file = "human",
                                  parallel.cores = 2)

negative_data <- extract_features(Seqs[6:10], label = "Coding",
                                  SS.features = FALSE, format = "DNA",
                                  frequencies.file = "human",
                                  parallel.cores = 2)

my_dataset <- rbind(positive_data, negative_data)

### Or use our data "demo_dataset"
data(demo_dataset)
my_dataset <- demo_dataset

optimal_parameter <- svm_tune(my_dataset, positive.class = "NonCoding",
                              folds.num = 2, seed = 1,
                              gamma.range = (2 ^ seq(-5, 0, 2)),
                              cost.range = c(1, 8, 16),
                              return.model = FALSE, parallel.core = 2)

### Users can set return.model = TRUE to return the best model.
}
}
\seealso{
\code{\link{extract_features}}, \code{\link{svm_cv}}.
}
\author{
HAN Siyu
}
