% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deseq_analysis.R
\name{Deseq_analysis}
\alias{Deseq_analysis}
\title{Deseq Analysis Function}
\usage{
Deseq_analysis(
  taxobj,
  taxlevel,
  comparison = NULL,
  cutoff,
  control_name,
  paired = FALSE,
  subject = NULL
)
}
\arguments{
\item{taxobj}{Taxonomic summary objects containing the taxonomic information, relative abundance, metafile and configuration.}

\item{taxlevel}{The taxonomic level for the analysis.Must be one of c("Domain","Phylum","Class","Order","Family","Genus","Species","Base")}

\item{comparison}{A vector of conditions to compare. Default: NULL, all unique conditions are compared (only for Two groups).}

\item{cutoff}{The log2 fold change cutoff for considering a taxon as differentially expressed.}

\item{control_name}{Character. The name of the control group for the comparison.}

\item{paired}{Logical. Should the samples be treated as paired? Default: False}

\item{subject}{Optional. The subject identifier for paired samples. Default: Null}
}
\value{
A data frame with the results of the differential expression analysis.
}
\description{
This function performs a differential expression analysis using the DESeq2 package.
It is designed to work with microbiome data and can handle paired or non-paired samples.
}
\note{
\enumerate{
\item Regulation is judged by cutoff of q-value(adjust p value).Detail see in \code{\link[DESeq2]{DESeq}}
\item For more than two groups in taxobj, the 'comparison' must be assigned.
\item The function requires the 'DESeq2', 'S4Vectors', and 'tibble' packages.
}
}
\examples{
\donttest{
if (requireNamespace("DESeq2", quietly = TRUE) &&
    requireNamespace("S4Vectors", quietly = TRUE) &&
    requireNamespace("tibble", quietly = TRUE)) {

    ### Data preparation ###
    data("Two_group")

    ### Deseq analysis ###
    deseq_results <- Deseq_analysis(
      taxobj = Two_group,
      taxlevel = "Genus",
      cutoff = 1,
      control_name = "Control"
    )

    # Visualization of volcano plot ##
    volcano_plot <- volcano_plot(
      inputframe = deseq_results,
      cutoff = 1,
      aes_col = Two_group$configuration$treat_col
    )
    volcano_plot$FC_FDR
    volcano_plot$Mean_FC

    # Visualization of Manhattan plot ##
    manhattan_object <- manhattan(
      inputframe = deseq_results,
      taxlevel = "Phylum",
      control_name = "Control",
      mode = "most",
      top_n = 10,
      rmprefix = "p__"
    )
    manhattan_object$manhattan  # Tradition manhattan plot
    manhattan_object$manhattan_circle  # Circular manhattan plot

    # For object with more than two groups
    ### Data preparation ###
    data("Three_group")

    # Specific comparison
    deseq_results_BFCF <- Deseq_analysis(
      taxobj = Three_group,
      taxlevel = "Genus",
      comparison = c("BF", "CF"),
      cutoff = 1,
      control_name = "CF"
    )
    volcano_plot <- volcano_plot(
      inputframe = deseq_results_BFCF,
      cutoff = 1,
      aes_col = Three_group$configuration$treat_col
    )
    volcano_plot$FC_FDR
  } else {
    message(
      "The 'DESeq2', 'S4Vectors', and/or 'tibble' package(s) are not installed. ",
      "Please install them to use all features of Deseq_analysis."
    )
  }
}
}
\seealso{
\code{\link[DESeq2]{DESeqDataSetFromMatrix}}, \code{\link[DESeq2]{DESeq}}, \code{\link[S4Vectors]{DataFrame}}, \code{\link[tibble]{as_tibble}}
}
\author{
Wang Ningqi \href{mailto:2434066068@qq.com}{2434066068@qq.com}
}
