% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NC_remove.R
\name{NC_remove}
\alias{NC_remove}
\title{Natural connectivity analysis}
\usage{
NC_remove(input, num, seed = 1)
}
\arguments{
\item{input}{Network adjacency matrix. Can be generated by \code{\link{network_analysis}}}

\item{num}{Max number of removed nodes. Default: Automatically match max number that can be removed.}

\item{seed}{Random seed Number to be set. Default: 1. See in \code{\link{set.seed}}}
}
\value{
NC_remove returns data frame with removed nodes and corresponding natural connectivity
}
\description{
Natural connectivity analysis
}
\examples{
\donttest{
{
  ### Data preparation ###
  data("Two_group")

  ### One input network analysis ###
  network_results <- network_analysis(
    taxobj = Two_group,
    taxlevel = "Base",
    reads = FALSE,
    n = 10,
    threshold = 0.6
  )

  network_matrix <- as.data.frame(network_results[[3]])  # Complete adjacency matrix

  # Check initial natural connectivity
  nc <- nc(network_matrix)

  # Conduct natural connectivity analysis
  nc_remove <- NC_remove(input = network_matrix)
  head(nc_remove)
  tail(nc_remove)

  # Set target number for natural connectivity analysis
  nc_remove <- NC_remove(input = network_matrix, num = 400)
}
}
}
\author{
Wang Ningqi\href{mailto:2434066068@qq.com}{2434066068@qq.com}
}
