% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template_DRAC.R
\name{template_DRAC}
\alias{template_DRAC}
\title{Create a DRAC input data template (v1.2)}
\usage{
template_DRAC(nrow = 1, preset = NULL, notification = TRUE)
}
\arguments{
\item{nrow}{\link{integer} (\emph{with default}):
specifies the number of rows of the template (i.e., the number of data
sets you want to submit).}

\item{preset}{\link{character} (\emph{optional}):
By default, all values of the template are set to \code{NA}, which means that
the user needs to fill in \strong{all} data first before submitting to DRAC
using \code{use_DRAC()}. To reduce the number of values that need to be
provided, \code{preset} can be used to create a template with at least
a minimum of reasonable preset values.

\code{preset} can be one of the following:
\itemize{
\item \code{quartz_coarse}
\item \code{quartz_fine}
\item \code{feldspar_coarse}
\item \code{polymineral_fine}
\item \code{DRAC-example_quartz}
\item \code{DRAC-example_feldspar}
\item \code{DRAC-example_polymineral}
}

Note that the last three options can be used to produce a template
with values directly taken from the official DRAC input .csv file.}

\item{notification}{\link{logical} (\emph{with default}):
show or hide the notification}
}
\value{
A list.
}
\description{
This function returns a DRAC input template (v1.2) to be used in conjunction
with the use_DRAC() function
}
\examples{

# create a new DRAC input input
input <- template_DRAC(preset = "DRAC-example_quartz")

# show content of the input
print(input)
print(input$`Project ID`)
print(input[[4]])


## Example: DRAC Quartz example
# note that you only have to assign new values where they
# are different to the default values
input$`Project ID` <- "DRAC-Example"
input$`Sample ID` <- "Quartz"
input$`Conversion factors` <- "AdamiecAitken1998"
input$`External U (ppm)` <- 3.4
input$`errExternal U (ppm)` <- 0.51
input$`External Th (ppm)` <- 14.47
input$`errExternal Th (ppm)` <- 1.69
input$`External K (\%)` <- 1.2
input$`errExternal K (\%)` <- 0.14
input$`Calculate external Rb from K conc?` <- "N"
input$`Calculate internal Rb from K conc?` <- "N"
input$`Scale gammadoserate at shallow depths?` <- "N"
input$`Grain size min (microns)` <- 90
input$`Grain size max (microns)` <- 125
input$`Water content ((wet weight - dry weight)/dry weight) \%` <- 5
input$`errWater content \%` <- 2
input$`Depth (m)` <- 2.2
input$`errDepth (m)` <- 0.22
input$`Overburden density (g cm-3)` <- 1.8
input$`errOverburden density (g cm-3)` <- 0.1
input$`Latitude (decimal degrees)` <- 30.0000
input$`Longitude (decimal degrees)` <- 70.0000
input$`Altitude (m)` <- 150
input$`De (Gy)` <- 20
input$`errDe (Gy)` <- 0.2

# use DRAC
\dontrun{
output <- use_DRAC(input)
}

} 

\section{How to cite}{
Burow, C., Kreutzer, S. (2018). template_DRAC(): Create a DRAC input data template (v1.2). In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2018). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.8.4. https://CRAN.R-project.org/package=Luminescence
}

\references{
Durcan, J.A., King, G.E., Duller, G.A.T., 2015. DRAC: Dose Rate and Age Calculator for trapped charge dating.
Quaternary Geochronology 28, 54-61. doi:10.1016/j.quageo.2015.03.012
}
\seealso{
\link{as.data.frame}, \link{list}
}
\author{
Christoph Burow, University of Cologne (Germany), Sebastian Kreutzer, IRAMAT-CRP2A, Université Bordeaux Montaigne (France)
}
