% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_BIN2CSV.R
\name{convert_BIN2CSV}
\alias{convert_BIN2CSV}
\title{Export Risoe BIN-file(s) to CSV-files}
\usage{
convert_BIN2CSV(file, ...)
}
\arguments{
\item{file}{\link{character} (\strong{required}):
name of the BIN-file to be converted to CSV-files}

\item{...}{further arguments that will be passed to the function
\link{read_BIN2R} and \link{write_RLum2CSV}}
}
\value{
The function returns either a CSV-file (or many of them) or for the
option \code{export == FALSE} a list comprising objects of type \link{data.frame} and \link{matrix}
}
\description{
This function is a wrapper function around the functions \link{read_BIN2R} and
\link{write_RLum2CSV} and it imports a Risoe BIN-file and directly exports its
content to CSV-files. If nothing is set for the argument \code{path}
(\link{write_RLum2CSV}) the input folder will become the output folder.
}
\section{Function version}{
 0.1.0 (2018-01-21 17:22:38)
}

\examples{

##transform Risoe.BINfileData values to a list
data(ExampleData.BINfileData, envir = environment())
convert_BIN2CSV(subset(CWOSL.SAR.Data, POSITION == 1), export = FALSE)

\dontrun{
##select your BIN-file
file <- file.choose()

##convert
convert_BIN2CSV(file)

}

}
\seealso{
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Data}, \linkS4class{RLum.Results},
\link[utils:write.table]{utils::write.table}, \link{write_RLum2CSV}, \link{read_BIN2R}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
\cr R Luminescence Package Team} 

\section{How to cite}{
Kreutzer, S. (2018). convert_BIN2CSV(): Export Risoe BIN-file(s) to CSV-files. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2018). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.8.6. https://CRAN.R-project.org/package=Luminescence
}

\keyword{IO}
