% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_SPE2R.R
\name{read_SPE2R}
\alias{read_SPE2R}
\title{Import Princeton Instruments (TM) SPE-file into R}
\usage{
read_SPE2R(
  file,
  output.object = "RLum.Data.Image",
  frame.range,
  txtProgressBar = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{file}{\link{character} (\strong{required}):
SPE-file name (including path), e.g.
\itemize{
\item \verb{[WIN]}: \code{read_SPE2R("C:/Desktop/test.spe")}
\item \verb{[MAC/LINUX]}: \code{readSPER("/User/test/Desktop/test.spe")}. Additionally internet connections
are supported.
}}

\item{output.object}{\link{character} (\emph{with default}):
set \code{RLum} output object.  Allowed types are \code{"RLum.Data.Spectrum"},
\code{"RLum.Data.Image"} or \code{"matrix"}}

\item{frame.range}{\link{vector} (\emph{optional}):
limit frame range, e.g. select first 100 frames by \code{frame.range = c(1,100)}}

\item{txtProgressBar}{\link{logical} (\emph{with default}):
enables or disables \link{txtProgressBar}.}

\item{verbose}{\link{logical} (\emph{with default}): enables or disables verbose mode}
}
\value{
Depending on the chosen option the functions returns three different
type of objects:

\code{output.object}

\code{RLum.Data.Spectrum}

An object of type \linkS4class{RLum.Data.Spectrum} is returned.  Row
sums are used to integrate all counts over one channel.

\code{RLum.Data.Image}

An object of type \linkS4class{RLum.Data.Image} is returned.  Due to
performance reasons the import is aborted for files containing more than 100
frames. This limitation can be overwritten manually by using the argument
\code{frame.range}.

\code{matrix}

Returns a matrix of the form: Rows = Channels, columns = Frames. For the
transformation the function \link{get_RLum} is used,
meaning that the same results can be obtained by using the function
\link{get_RLum} on an \code{RLum.Data.Spectrum} or \code{RLum.Data.Image} object.
}
\description{
Function imports Princeton Instruments (TM) SPE-files into R environment and
provides \linkS4class{RLum.Data.Image} objects as output.
}
\details{
Function provides an R only import routine for the Princeton Instruments
SPE format. Import functionality is based on the file format description provided by
Princeton Instruments and a MatLab script written by Carl Hall (s.
references).
}
\note{
\strong{The function does not test whether the input data are spectra or pictures for spatial resolved analysis!}

The function has been successfully tested for SPE format versions 2.x.

\emph{Currently not all information provided by the SPE format are supported.}
}
\section{Function version}{
 0.1.4
}

\examples{

## to run examples uncomment lines and run the code

##(1) Import data as RLum.Data.Spectrum object
#file <- file.choose()
#temp <- read_SPE2R(file)
#temp

##(2) Import data as RLum.Data.Image object
#file <- file.choose()
#temp <- read_SPE2R(file, output.object = "RLum.Data.Image")
#temp

##(3) Import data as matrix object
#file <- file.choose()
#temp <- read_SPE2R(file, output.object = "matrix")
#temp

##(4) Export raw data to csv, if temp is a RLum.Data.Spectrum object
# write.table(x = get_RLum(temp),
#             file = "[your path and filename]",
#             sep = ";", row.names = FALSE)


} 

\section{How to cite}{
Kreutzer, S., 2023. read_SPE2R(): Import Princeton Instruments (TM) SPE-file into R. Function version 0.1.4. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2023. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.22. https://CRAN.R-project.org/package=Luminescence
}

\references{
Princeton Instruments, 2014. Princeton Instruments SPE 3.0 File
Format Specification, Version 1.A (for document URL please use an internet search machine)

Hall, C., 2012: readSPE.m.
\verb{https://www.mathworks.com/matlabcentral/fileexchange/35940-readspe}
}
\seealso{
\link{readBin}, \linkS4class{RLum.Data.Spectrum}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{IO}
