% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_IrradiationTimes.R
\name{extract_IrradiationTimes}
\alias{extract_IrradiationTimes}
\title{Extract Irradiation Times from an XSYG-file}
\usage{
extract_IrradiationTimes(
  object,
  file.BINX,
  recordType = c("irradiation (NA)", "IRSL (UVVIS)", "OSL (UVVIS)", "TL (UVVIS)"),
  compatibility.mode = TRUE,
  txtProgressBar = TRUE
)
}
\arguments{
\item{object}{\link{character}, \linkS4class{RLum.Analysis} or \link{list} (\strong{required}):
path and file name of the XSYG file or an \linkS4class{RLum.Analysis}
produced by the function \link{read_XSYG2R};
alternatively a \code{list} of \linkS4class{RLum.Analysis} can be provided.

\strong{Note}: If an \linkS4class{RLum.Analysis} is used, any input for
the arguments \code{file.BINX} and \code{recordType} will be ignored!}

\item{file.BINX}{\link{character} (\emph{optional}):
path and file name of an existing BINX-file. If a file name is provided the
file will be updated with the information from the XSYG file in the same
folder as the original BINX-file.

\strong{Note:} The XSYG and the BINX-file must originate from the
same measurement!}

\item{recordType}{\link{character} (\emph{with default}):
select relevant curves types from the XSYG file or \linkS4class{RLum.Analysis}
object. As the XSYG-file format comprises much more information than usually
needed for routine data analysis and allowed in the BINX-file format, only
the relevant curves are selected by using the function
\link{get_RLum}. The argument \code{recordType} works as
described for this function.

\strong{Note:} A wrong selection will causes a function error. Please change this
argument only if you have reasons to do so.}

\item{compatibility.mode}{\link{logical} (\emph{with default}):
this option is parsed only if a BIN/BINX file is produced and it will reset all position
values to a max. value of 48, cf.\link{write_R2BIN}}

\item{txtProgressBar}{\link{logical} (\emph{with default}):
enable/disable the progress bar during import and export.}
}
\value{
An \linkS4class{RLum.Results} object is returned with the
following structure:

\if{html}{\out{<div class="sourceCode">}}\preformatted{.. $irr.times (data.frame)
}\if{html}{\out{</div>}}

If a BINX-file path and name is set, the output will be additionally
transferred into a new BINX-file with the function name as suffix. For the
output the path of the input BINX-file itself is used. Note that this will
not work if the input object is a file path to an XSYG-file, instead of a
link to only one file. In this case the argument input for \code{file.BINX} is ignored.

In the self call mode (input is a \code{list} of \linkS4class{RLum.Analysis} objects
a list of \linkS4class{RLum.Results} is returned.
}
\description{
Extracts irradiation times, dose and times since last irradiation, from a
Freiberg Instruments XSYG-file. These information can be further used to
update an existing BINX-file.
}
\details{
The function was written to compensate missing information in the BINX-file
output of Freiberg Instruments lexsyg readers. As all information are
available within the XSYG-file anyway, these information can be extracted
and used for further analysis or/and to stored in a new BINX-file, which can
be further used by other software, e.g., Analyst (Geoff Duller).

Typical application example: g-value estimation from fading measurements
using the Analyst or any other self-written script.

Beside some simple data transformation steps, the function applies
functions \link{read_XSYG2R}, \link{read_BIN2R}, \link{write_R2BIN} for data import and export.
}
\note{
The function can be also used to extract irradiation times from \linkS4class{RLum.Analysis} objects
previously imported via \link{read_BIN2R} (\code{fastForward = TRUE}) or in combination with \link{Risoe.BINfileData2RLum.Analysis}.
Unfortunately the timestamp might not be very precise (or even invalid),
but it allows to essentially treat different formats in a similar manner.

The produced output object contains still the irradiation steps to
keep the output transparent. However, for the BINX-file export this steps
are removed as the BINX-file format description does not allow irradiations
as separate sequences steps.

\strong{BINX-file 'Time Since Irradiation' value differs from the table output?}

The way the value 'Time Since Irradiation' is defined differs. In the BINX-file the
'Time Since Irradiation' is calculated as the 'Time Since Irradiation' plus the 'Irradiation
Time'. The table output returns only the real 'Time Since Irradiation', i.e. time between the
end of the irradiation and the next step.

\strong{Negative values for \code{TIMESINCELAST.STEP}?}

Yes, this is possible and no bug, as in the XSYG-file multiple curves are stored for one step.
Example: TL step may comprise three curves:
\itemize{
\item (a) counts vs. time,
\item (b) measured temperature vs. time and
\item (c) predefined temperature vs. time.
}

Three curves, but they are all belonging to one TL measurement step, but with regard to
the time stamps this could produce negative values as the important function
(\link{read_XSYG2R}) do not change the order of entries for one step
towards a correct time order.
}
\section{Function version}{
 0.3.4
}

\examples{
## (1) - example for your own data
##
## set files and run function
#
#   file.XSYG <- file.choose()
#   file.BINX <- file.choose()
#
#     output <- extract_IrradiationTimes(file.XSYG = file.XSYG, file.BINX = file.BINX)
#     get_RLum(output)
#
## export results additionally to a CSV-file in the same directory as the XSYG-file
#       write.table(x = get_RLum(output),
#                   file = paste0(file.BINX,"_extract_IrradiationTimes.csv"),
#                   sep = ";",
#                   row.names = FALSE)

} 

\section{How to cite}{
Kreutzer, S., 2025. extract_IrradiationTimes(): Extract Irradiation Times from an XSYG-file. Function version 0.3.4. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.0.0. https://r-lum.github.io/Luminescence/
}

\references{
Duller, G.A.T., 2015. The Analyst software package for luminescence data: overview and
recent improvements. Ancient TL 33, 35-42.
}
\seealso{
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}, \linkS4class{Risoe.BINfileData},
\link{read_XSYG2R}, \link{read_BIN2R}, \link{write_R2BIN}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{IO}
\keyword{manip}
