% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R
\name{structure_RLum}
\alias{structure_RLum}
\alias{structure_RLum,list-method}
\title{General structure function for RLum S4 class objects}
\usage{
structure_RLum(object, ...)

\S4method{structure_RLum}{list}(object, ...)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum}}

\item{...}{further arguments passed to the specific class method}
}
\value{
Returns a \link{data.frame} with structure of the object.
}
\description{
The function provides a generalised access point for specific
\linkS4class{RLum} objects. Depending on the input object, the corresponding
function will be selected.
Allowed arguments can be found in the documentations of the corresponding
\linkS4class{RLum} class.
}
\section{Functions}{
\itemize{
\item \code{structure_RLum(list)}: Returns a list of \linkS4class{RLum} objects that were passed to \link{structure_RLum}

}}
\section{Function version}{
 0.2.0
}

\examples{

## load example data
data(ExampleData.XSYG, envir = environment())

## show structure
structure_RLum(OSL.SARMeasurement$Sequence.Object)

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Image},
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. structure_RLum(): General structure function for RLum S4 class objects. Function version 0.2.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.0. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
