% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Risoe.BINfileData2RLum.Analysis.R
\name{Risoe.BINfileData2RLum.Analysis}
\alias{Risoe.BINfileData2RLum.Analysis}
\title{Convert Risoe.BINfileData object to an RLum.Analysis object}
\usage{
Risoe.BINfileData2RLum.Analysis(
  object,
  pos = NULL,
  grain = NULL,
  run = NULL,
  set = NULL,
  ltype = NULL,
  dtype = NULL,
  protocol = "unknown",
  keep.empty = TRUE,
  txtProgressBar = FALSE
)
}
\arguments{
\item{object}{\linkS4class{Risoe.BINfileData} (\strong{required}):
object to convert.}

\item{pos}{\link{numeric} (\emph{optional}): position number of the \code{Risoe.BINfileData}
object for which the curves are stored in the \code{RLum.Analysis} object.
If \code{length(pos) > 1}, a list of \code{RLum.Analysis} objects is returned.
If nothing is provided every position will be converted.
If the position is not valid \code{NULL} is returned.}

\item{grain}{\link{vector}, \link{numeric} (\emph{optional}):
grain number from the measurement to limit the converted data set
(e.g., \code{grain = c(1:48)}). Please be aware that this option may lead to
unwanted effects, as the output is strictly limited to the chosen grain
number for all position numbers.}

\item{run}{\link{vector}, \link{numeric} (\emph{optional}):
run number from the measurement to limit the converted data set
(e.g., \code{run = c(1:48)}).}

\item{set}{\link{vector}, \link{numeric} (\emph{optional}):
set number from the measurement to limit the converted data set
(e.g., \code{set = c(1:48)}).}

\item{ltype}{\link{vector}, \link{character} (\emph{optional}):
curve type to limit the converted data. Commonly allowed values are:
\code{IRSL}, \code{OSL}, \code{TL}, \code{RIR}, \code{RBR} and \code{USER}
(see also \linkS4class{Risoe.BINfileData}).}

\item{dtype}{\link{vector}, \link{character} (\emph{optional}):
data type to limit the converted data. Commonly allowed values are
listed in \linkS4class{Risoe.BINfileData}.}

\item{protocol}{\link{character} (\emph{optional}):
sets protocol type for analysis object. Value may be used by subsequent
analysis functions.}

\item{keep.empty}{\link{logical} (\emph{with default}):
If \code{TRUE} (default) an \code{RLum.Analysis} object is returned even if it does
not contain any records. Set to \code{FALSE} to discard all empty objects.}

\item{txtProgressBar}{\link{logical} (\emph{with default}):
enable/disable the progress bar.}
}
\value{
Returns an \linkS4class{RLum.Analysis} object.
}
\description{
Converts values from one specific position of a \linkS4class{Risoe.BINfileData}
object to an \linkS4class{RLum.Analysis} object.

The \linkS4class{RLum.Analysis} object requires a set of curves for
specific further protocol analyses. However, the \linkS4class{Risoe.BINfileData}
usually contains a set of curves for different aliquots and different
protocol types that may be mixed up. Therefore, a conversion is needed.
}
\note{
The \code{protocol} argument of the \linkS4class{RLum.Analysis}
object is set to 'unknown' if not stated otherwise.
}
\section{Function version}{
 0.4.3
}

\examples{

##load data
data(ExampleData.BINfileData, envir = environment())

##convert values for position 1
Risoe.BINfileData2RLum.Analysis(CWOSL.SAR.Data, pos = 1)

}
\seealso{
\linkS4class{Risoe.BINfileData}, \linkS4class{RLum.Analysis}, \link{read_BIN2R}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. Risoe.BINfileData2RLum.Analysis(): Convert Risoe.BINfileData object to an RLum.Analysis object. Function version 0.4.3. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\keyword{manip}
