% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maivefunction.r
\name{waive}
\alias{waive}
\title{WAIVE: Weighted Adjusted Instrumental Variable Estimator}
\usage{
waive(dat, method, weight, instrument, studylevel, SE, AR, first_stage = 0L)
}
\arguments{
\item{dat}{Data frame with columns bs, sebs, Ns, study_id (optional).}

\item{method}{1 FAT-PET, 2 PEESE, 3 PET-PEESE, 4 EK.}

\item{weight}{0 no weights, 1 standard weights, 2 MAIVE adjusted weights, 3 study weights.}

\item{instrument}{1 yes, 0 no.}

\item{studylevel}{Correlation at study level: 0 none, 1 fixed effects, 2 cluster.}

\item{SE}{SE estimator: 0 CR0 (Huber-White), 1 CR1 (Standard empirical correction),
2 CR2 (Bias-reduced estimator), 3 wild bootstrap.}

\item{AR}{Anderson Rubin corrected CI for weak instruments (available for unweighted and MAIVE-adjusted weight versions of
PET, PEESE, PET-PEESE, not available for fixed effects): 0 no, 1 yes.}

\item{first_stage}{First-stage specification for the variance model: 0 levels, 1 log.}
}
\value{
List with the same structure as \code{maive()}. See \code{?maive} for details.
}
\description{
WAIVE extends MAIVE by applying exponential-decay weights that downweight
studies with spurious precision or extreme outlier behavior.
}
\details{
Computes robust downweighting based on first-stage residuals. Studies with
negative residuals (spurious precision) or extreme residuals (outliers) receive
reduced influence in the meta-analytic estimate.
}
\examples{
dat <- data.frame(
  bs = c(0.5, 0.45, 0.55, 0.6),
  sebs = c(0.25, 0.2, 0.22, 0.27),
  Ns = c(50, 80, 65, 90)
)

result <- waive(dat,
  method = 3, weight = 0, instrument = 1,
  studylevel = 0, SE = 0, AR = 0, first_stage = 0
)

}
\seealso{
\code{\link{maive}}
}
