% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MANOVAwide-function.R
\name{MANOVA.wide}
\alias{MANOVA.wide}
\title{Tests for Multivariate Data in Semi-Parametric Factorial Designs}
\usage{
MANOVA.wide(formula, data, iter = 10000, alpha = 0.05,
  resampling = "paramBS", CPU, seed, nested.levels.unique = FALSE)
}
\arguments{
\item{formula}{A model \code{\link{formula}} object. The left hand side 
contains the matrix of response variables and the right hand side contains the factor 
variables of interest. An interaction term must be specified.}

\item{data}{A data.frame, list or environment containing the variables in 
\code{formula}. Data must be in wide format.}

\item{iter}{The number of iterations used for calculating the resampled 
statistic. The default option is 10,000.}

\item{alpha}{A number specifying the significance level; the default is 0.05.}

\item{resampling}{The resampling method to be used, one of "paramBS"
(parametric bootstrap approach) and "WildBS" (wild bootstrap approach with
Rademacher weights). The Wild Bootstrap is calculated for all test statistics.}

\item{CPU}{The number of cores used for parallel computing. If omitted, cores are
detected via \code{\link[parallel]{detectCores}}.}

\item{seed}{A random seed for the resampling procedure. If omitted, no 
reproducible seed is set.}

\item{nested.levels.unique}{A logical specifying whether the levels of the nested factor(s)
are labeled uniquely or not. Default is FALSE, i.e., the levels of the nested 
factor are the same for each level of the main factor. For an example and more explanations
see the GFD package and the corresponding vignette.}
}
\value{
See \code{\link{MANOVA}}
}
\description{
The MANOVA.wide function calculates the Wald-type statistic (WTS), the ANOVA-type 
statistic (ATS) and a modified ATS (MATS) as well as resampling versions of 
these test statistics for 
semi-parametric multivariate data provided in wide format.
}
\section{NOTE}{
 The number of resampling iterations has been set to 100 in the examples due to run time 
restrictions on CRAN. Usually it is recommended to use at least 1000 iterations.
}
\examples{
#Example on producing plastic film from Krzanowski (1998, p. 381), see \\code{\\link{manova.summary}}
tear <- c(6.5, 6.2, 5.8, 6.5, 6.5, 6.9, 7.2, 6.9, 6.1, 6.3,
          6.7, 6.6, 7.2, 7.1, 6.8, 7.1, 7.0, 7.2, 7.5, 7.6)
gloss <- c(9.5, 9.9, 9.6, 9.6, 9.2, 9.1, 10.0, 9.9, 9.5, 9.4,
           9.1, 9.3, 8.3, 8.4, 8.5, 9.2, 8.8, 9.7, 10.1, 9.2)
opacity <- c(4.4, 6.4, 3.0, 4.1, 0.8, 5.7, 2.0, 3.9, 1.9, 5.7,
             2.8, 4.1, 3.8, 1.6, 3.4, 8.4, 5.2, 6.9, 2.7, 1.9)
rate     <- gl(2,10, labels = c("Low", "High"))
additive <- gl(2, 5, length = 20, labels = c("Low", "High"))
example <- data.frame(tear, gloss, opacity, rate, additive)
fit <- MANOVA.wide(cbind(tear, gloss, opacity) ~ rate * additive, 
data = example, iter = 100, CPU = 1)
summary(fit)

}
\seealso{
\code{\link{MANOVA}}
}

