% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARX_functions.R
\name{inference}
\alias{inference}
\title{Asymptotic inference for the MARX function}
\usage{
inference(y, x, B_C, B_NC, B_x, IC, sig, df, sig_level)
}
\arguments{
\item{y}{Data vector of time series observations.}

\item{x}{Matrix of data (every column represents one time series). Specify NULL or "not" if not wanted.}

\item{B_C}{Estimated causal parameters of the MARX.}

\item{B_NC}{Estimated noncausal parameters of the MARX.}

\item{B_x}{Estimated parameters of the exogenous variables in the MARX.}

\item{IC}{Estimated intercept.}

\item{sig}{Estimated scale parameter of the assumed underlying Student-t distribution of the residuals.}

\item{df}{Estimated degrees of freedom of the assumed underlying Student-t distribution of the residuals.}

\item{sig_level}{Significance level for the construction of inference.}
}
\value{
\item{CI.c}{Confidence intervals for causal parameters.}

\item{CI.nc}{Confidence intervals for noncausal parameters.}

\item{CI.exo}{Confidence intervals for exogenous parameters.}

\item{CI.int}{Confidence interval for intercept.}

\item{se.c}{Standard errors of causal parameters.}

\item{se.nc}{Standard errors of noncausal parameters.}

\item{se.exo}{Standard errors of exogenous parameters.}

\item{se.int}{Standard error of intercept.}
}
\description{
This function allows you to calculate standard errors and confidence intervals for parameters of the MARX model.
}
\examples{
data <- sim.marx(c('t',1,1), c('t',1,1),100,0.5,0.4,0.3)
y <- data$y
x <- data$x
res <- marx.t(y,x,1,1)
inference(y,x,res$coef.c,res$coef.nc,res$coef.exo,res$coef.int,res$scale,res$df,0.05)
}
\author{
Sean Telg
}
\keyword{causal-noncausal}
\keyword{inference}
