% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.MBWCov.R
\name{summary.MBWCov}
\alias{summary.MBWCov}
\title{Summary Results for Multiblock Weighted Covariate analysis (MB-WCov)}
\usage{
\method{summary}{MBWCov}(object, nvar = NULL, ncompprint = NULL, digits = 2, ...)
}
\arguments{
\item{object}{An object of class \code{MBWCov}.}

\item{nvar}{Number of variables to print. By default (NULL), all the variables are printed.}

\item{ncompprint}{Number of global components to print.
By default (NULL), the number of global components printed for the main function MBWCov.}

\item{digits}{Number of decimal points (by default 2).}

\item{...}{Further arguments.}
}
\value{
Returns the percentages of inertia explained by successive global components (for both X and Y), their cumulative values,
the saliences and the correlations of the variables with the global components.
}
\description{
Gives key results for MB-WCov.
}
\examples{
data(ham)
X=ham$X
group=ham$group
Y=ham$Y
res.mbwcov <- MBWCov(X, Y, group, plotgraph=FALSE)
summary(res.mbwcov)
}
\seealso{
\code{\link{MBWCov}}
}
\author{
Essomanda TCHANDAO MANGAMANA \email{tchanesso@yahoo.fr}, Véronique CARIOU, Evelyne VIGNEAU.
}
