% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inconsistency.functions.R, R/plot.functions.R
\name{nma.nodesplit}
\alias{nma.nodesplit}
\alias{plot.nma.nodesplit}
\title{Node-splitting model for testing consistency at the treatment level}
\usage{
nma.nodesplit(network, likelihood = NULL, link = NULL,
  method = "common", comparisons = NULL, drop.discon = TRUE, ...)

\method{plot}{nma.nodesplit}(x, plot.type = NULL, ...)
}
\arguments{
\item{network}{An object of class \code{mbnma.network}.}

\item{likelihood}{A string indicating the likelihood to use in the model. Can take either \code{"binomial"},
\code{"normal"} or \code{"poisson"}. If left as \code{NULL} the likelihood will be inferred from the data.}

\item{link}{A string indicating the link function to use in the model. Can take any link function
defined within JAGS (e.g. \code{"logit"}, \code{"log"}, \code{"probit"}, \code{"cloglog"}) or be assigned the value \code{"identity"} for
and identity link function. If left as \code{NULL} the link function will be automatically assigned based
on the likelihood.}

\item{method}{Can take either \code{"common"} or \code{"random"} to indicate whether relative effects
should be modelled with between-study heterogeneity or not (see details).}

\item{comparisons}{A matrix specifying the comparisons to be split (one row per comparison).
The matrix must have two columns indicating each treatment for each comparison. Values can
either be character (corresponding to the treatment names given in \code{network}) or
numeric (corresponding to treatment codes within the \code{network} - note that these
may change if \code{drop.discon = TRUE}).}

\item{drop.discon}{A boolean object that indicates whether to drop treatments
that are disconnected at the treatment level. Default is \code{TRUE}. If set to \code{FALSE} then
this could lead to identification of nodesplit comparisons that are not connected
to the network reference treatment, or lead to errors in running the nodesplit models, though it
can be useful for error checking.}

\item{...}{Arguments to be sent to \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}}

\item{x}{An object of \code{class("nma.nodesplit")}}

\item{plot.type}{A character string that can take the value of \code{"forest"} to plot
only forest plots, \code{"density"} to plot only density plots, or left as \code{NULL} (the
default) to plot both types of plot.}
}
\value{
Plots the desired graph(s) and returns an object (or list of object if
\code{plot.type=NULL}) of \code{class(c("gg", "ggplot"))}
}
\description{
Splits contributions for a given set of treatment comparisons into direct and
indirect evidence. A discrepancy between the two suggests that the consistency
assumption required for NMA and MBNMA may violated.
}
\details{
The S3 method \code{plot()} on an \code{nma.nodesplit} object generates either
forest plots of posterior medians and 95\% credible intervals, or density plots
of posterior densities for direct and indirect evidence.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Plot outputs from treatment-level nodesplit models
}}

\examples{
\donttest{
# Using the triptans data
network <- mbnma.network(HF2PPITT)

split <- nma.nodesplit(network, likelihood = "binomial", link="logit",
  method="common")



#### To perform nodesplit on selected comparisons ####

# Check for closed loops of treatments with independent evidence sources
loops <- inconsistency.loops(network$data.ab)

# This...
single.split <- nma.nodesplit(network, likelihood = "binomial", link="logit",
             method="random", comparisons=rbind(c("sumatriptan_1", "almotriptan_1")))

#...is the same as...
single.split <- nma.nodesplit(network, likelihood = "binomial", link="logit",
             method="random", comparisons=rbind(c(6, 12)))


# Plot results
plot(split, plot.type="density") # Plot density plots of posterior densities
plot(split, plot.type="forest") # Plot forest plots of direct and indirect evidence

# Print and summarise results
print(split)
summary(split) # Generate a data frame of summary results
}
}
