% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.functions.R
\name{write.alpha}
\alias{write.alpha}
\title{Adds sections of JAGS code for an MBNMA model that correspond to alpha
parameters}
\usage{
write.alpha(model, timecourse, intercept, positive.scale)
}
\arguments{
\item{model}{A character string representing the MBNMA model in JAGS code}

\item{timecourse}{A character object that contains JAGS code for the
time-course component of the model}

\item{intercept}{A boolean object that indicates whether an intercept is to
be included in the model. Can be used to imply whether mean responses in
data are change from baseline (\code{FALSE}) or not (setting it to \code{FALSE}
removes the intercept, \code{alpha}, from the model).}

\item{positive.scale}{A boolean object that indicates whether all continuous
mean responses (y) are positive and therefore whether the baseline response
should be given a prior that constrains it to be positive.}
}
\value{
A list of named elements: \code{model} is a character object of JAGS MBNMA
model code that includes alpha parameter components of the model
\code{timecourse} is a character object that contains JAGS code for the
time-course component of the model, for which alpha will be indexed
correctly
}
\description{
Adds sections of JAGS code for an MBNMA model that correspond to alpha
parameters
}
