% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.functions.R
\name{nma.run}
\alias{nma.run}
\title{Run an NMA model}
\usage{
nma.run(data.ab, method = "common", link = "identity", ...)
}
\arguments{
\item{data.ab}{A data frame of arm-level data in "long" format containing the columns:
\itemize{
\item \code{studyID} Study identifiers
\item \code{time} Numeric data indicating follow-up times
\item \code{y} Numeric data indicating the aggregate response for a given observation (e.g. mean)
\item \code{se} Numeric data indicating the standard error for a given observation
\item \code{treatment} Treatment identifiers (can be numeric, factor or character)
\item \code{class} An optional column indicating a particular class identifier. Observations with the same treatment
identifier must also have the same class identifier.
\item \code{n} An optional column indicating the number of participants used to calculate the
response at a given observation (required if modelling using Standardised Mean Differences)
}}

\item{method}{Can take \code{"common"} or \code{"random"} to indicate the type of NMA model used to synthesise data points
given in \code{overlay.nma}. The default is \code{"random"} since this assumes different
time-points in \code{overlay.nma} have been lumped together to estimate the NMA.}

\item{link}{Can take either \code{"identity"} (the default),
\code{"log"} (for modelling Ratios of Means \insertCite{friedrich2011}{MBNMAtime}) or
\code{"smd"} (for modelling Standardised Mean Differences - although this also corresponds to an identity link function).}

\item{...}{Options for plotting in \code{igraph}.}
}
\value{
Returns an object of \code{class("nma", "rjags")}
}
\description{
Run an NMA model
}
\examples{
network <- mb.network(osteopain)

# Get the latest time point
df <- get.latest.time(network)

# Run NMA on the data
nma.run(df, method="random")

}
