% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodesplit.functions.R
\name{mb.nodesplit.comparisons}
\alias{mb.nodesplit.comparisons}
\title{Identify comparisons in time-course MBNMA datasets that fulfil criteria for node-splitting}
\usage{
mb.nodesplit.comparisons(network)
}
\arguments{
\item{network}{An object of class \code{"mb.network"}.}
}
\value{
A data frame of comparisons that are informed by direct and indirect
evidence from independent sources. Each row of the data frame is a
different treatment comparison. Numerical codes in \code{t1} and \code{t2} correspond
to treatment codes.
}
\description{
Identify comparisons informed by both direct and indirect evidence from independent sources in MBNMA
datasets with repeated measurements in each study. These comparisons are therefore those which
fulfil the criteria for testing for inconsistency via node-splitting, following the method of van
Valkenhoef \insertCite{vanvalkenhoef2016;textual}{MBNMAtime}.
}
\details{
Similar to \code{gemtc::mtc.nodesplit()} but uses a fixed
reference treatment and therefore suggests fewer loops in which to test for
inconsistency. Heterogeneity can also be parameterised as inconsistency and
so testing for inconsistency in additional loops whilst changing the
reference treatment would also be identifying heterogeneity. Depends on \code{\link[igraph]{igraph}}.
}
\examples{
# Create mb.network object
network <- mb.network(osteopain)

# Identify comparisons informed by direct and indirect evidence
mb.nodesplit.comparisons(network)
}
\references{
\insertAllCited
}
