% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDEI_summary_plot.R
\name{coverPlot}
\alias{coverPlot}
\title{Coverage Plot for MDEI Object}
\usage{
coverPlot(
  object,
  xvar = "treat",
  sigval = 0,
  target = "tau",
  colors = c(gray(0.7), gray(0)),
  cex.point = 0.5,
  xlabel = "",
  ylabel = "",
  ...
)
}
\arguments{
\item{object}{An object of class MDEI.}

\item{xvar}{The variable to plot along the x-axis.  May be `treat` for the treatment
variable, the name of a column in the covariate matrix in the \code{obj}, or a numeric vector,
the length of the data.   Default is \code{"treat"}.}

\item{sigval}{The value to see if it is covered by the conformal interval. Either a single value or a vector.   Default is \code{0}.}

\item{target}{Either tau` or `theta`.  The first, `tau`, is the marginal effect at each point, while the second
`theta`, is the portion of the conditional mean of the outcome that is a function of the treatment and the outcome.}

\item{colors}{A vector with two elements.  The first is the color of the confidence interval at points
where the conformal interval does not contain \code{sigval}, the second the color where it does.   Default is \code{c(gray(.7), gray(0))}.}

\item{cex.point}{The size of the points in the figure.  Default is \code{0.5}.}

\item{xlabel}{Label for x-axis of figure.  Default is \code{""}.}

\item{ylabel}{Label for y-axis of figure.  Default is \code{""}.}

\item{...}{Additional arguments to be passed to \code{plot}.}
}
\value{
No return value.
}
\description{
Coverage Plot for MDEI Object
}
