%  Copyright (C) 2015 Christian Margreitter
\name{hbond}
\alias{hbond}
\title{Plot hydrogen bond summary}
\description{This function plots the summary output of hydrogen bond calculations and allows selection of donor and acceptor residues and atoms. Occurence over the whole trajectory is indicated by a colour scale. A legend indicating the colour scale can be printed.}
\usage{
hbond( hbonds,
       plotMethod = "residue-wise",
       acceptorRange = NA,
       donorRange = NA,
       printLegend = TRUE,
       barePlot = FALSE,
       ... )}
\arguments{
  \item{hbonds}{Table containing the hydrogen bond information in the columns \code{hbondID}, \code{resDonor}, \code{resDonorName}, \code{resAcceptor}, \code{resAcceptorName}, \code{atomDonor}, \code{atomDonorName}, \code{atomH}, \code{atomAcceptor}, \code{AtomAcceptorName}, \code{percentage} (automatically generated by function \code{MDplot::load_hbond()}).}
  \item{plotMethod}{Allows to set the detail of hbond information displayed. Options are:
                    \itemize{\item \code{residue-wise}}}
  \item{acceptorRange}{Vector, specifying which range of acceptor residues is used.}
  \item{donorRange}{Vector, specifying which range of donor residues is used.}
  \item{printLegend}{Boolean, used to print or hide the legend for the occurences.}
  \item{barePlot}{Boolean, indicating whether the plot is to be made without any additional information.}
  \item{...}{Additional arguments (ellipsis).}
}
\examples{
# see "extdata/hbond_example.txt.gz" for format information
hbond( load_hbond( system.file( "extdata/hbond_example.txt.gz",
                                package = "MDplot" ) ) )
}
\author{Christian Margreitter}
\keyword{hbond}
\keyword{hydrogen bond}
