% (C) 2015 Christian Margreitter
% last update: 2017-02-21
\name{TIcurve}
\alias{TIcurve}
\title{Thermodynamic integration plot}
\description{Plot the thermodynamic integration(s) (TIs) specified in the input files. Files have to have at least three columns (lambda point, free energy and error) in order to be valid. In addition, the delta free energiy (to a precision dependent on the error) are calculated. In case, two data input series are provided, the hysteresis is calculated.}
\usage{
TIcurve( lambdas,
         invertedBackwards = FALSE,
         energyUnit = "kJ/mol",
         printValues = TRUE,
         printErrors = TRUE,
         errorBarThreshold = 0,
         barePlot = FALSE,
         ... )}
\arguments{
  \item{lambdas}{List of matrices (automatically generated by \code{\link{load_TIcurve}()}) holding the thermodynamic integration information.}
  \item{invertedBackwards}{In case a forward and backward TI have been performed and the lambda points are enumerated reversely (i.e. 0.3 of one TI is equivalent to 0.7 of the other), this flag can be set to be \code{TRUE} in order to automatically mirror the values appropriately.}
  \item{energyUnit}{Defines the energy unit used for the plot.}
  \item{printValues}{Boolean, indicating whether the computed integration and error values are to be plotted.}
  \item{printErrors}{Boolean, indicating whether error bars are to be plotted.}
  \item{errorBarThreshold}{If the error at a given lambda point is below this theshold, it is not plotted.}
  \item{barePlot}{Boolean, indicating whether the plot is to be made without any additional information.}
  \item{...}{Additional arguments (ellipsis).}
}
\value{
Returns a list with the the following information:
\itemize{\item{\code{lambdapoints}} A list containing a (at least) \code{n}x3-matrix for every data input series.
\item{\code{integrationresults}} A matrix containing one row of "deltaG" and "error" columns from the integration for every data input series.
\item{\code{hysteresis}} If two (i.e. forward and backward) data input series are provided, the resulting hysteresis is reported (and set to be \code{NA} otherwise).
}}
\examples{
# GROMOS (forward integration)
TIcurve( load_TIcurve( system.file( "extdata/TIcurve_example.txt.gz",
                                    package = "MDplot" ) ) )

# GROMOS (forward and backward integration)
TIcurve( load_TIcurve( c( system.file( "extdata/TIcurve_fb_forward_example.txt.gz",
                                       package = "MDplot" ),
                          system.file( "extdata/TIcurve_fb_backward_example.txt.gz",
                          package = "MDplot" ) ) ),
         invertedBackwards = TRUE )
}
\author{Christian Margreitter}
\keyword{Thermodynamic integration}