% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCP_TPA.R
\name{findAlphaVopt}
\alias{findAlphaVopt}
\alias{findAlphaWopt}
\title{Find the optimal smoothing parameters in FCP_TPA using GCV}
\usage{
findAlphaVopt(alphaRange, data, u, w, alphaW, OmegaW, GammaV, lambdaV)

findAlphaWopt(alphaRange, data, u, v, alphaV, OmegaV, GammaW, lambdaW)
}
\arguments{
\item{alphaRange}{A numeric vector with two elements, containing the minimal 
and maximal value for the smoothing parameter that is to be optimized.}

\item{data}{The tensor containing the data, an array of dimensions \code{N x 
S1 x S2}.}

\item{u, v, w}{The current value of the eigenvectors \eqn{u_k, v_k, w_k} (not 
normalized) of dimensions \code{N}, \code{S1} and \code{S2}.}

\item{GammaV, GammaW}{A matrix of dimension \code{S1 x S1} (\code{GammaV} in  \code{findAlphaVopt}) or \code{S2 x S2} (\code{GammaW} in  \code{findAlphaWopt}), containing the 
eigenvectors of the penalty matrix for the image direction for which the optimal smoothing parameter is to be found.}

\item{lambdaV, }{lambdaW A numeric vector of length  \code{S1}(\code{lambdaV} in  \code{findAlphaVopt}) or \code{S2} (\code{lambdaW} in  \code{findAlphaWopt}), containing the 
eigenvalues of the penalty matrix for the image direction for which the optimal smoothing parameter is to be found.}

\item{alphaV, alphaW}{The current value of the smoothing parameter for the
other image direction (\eqn{\alpha_w} for \code{findAlphaVopt} and
\eqn{\alpha_v} for \code{findAlphaWopt}), which is kept as fixed.}

\item{OmegaV, }{OmegaW A matrix of dimension \code{S1 x S1} (\code{OmegaV} in  \code{findAlphaWopt}) or \code{S2 x S2} (\code{OmegaW} in  \code{findAlphaVopt}), the penalty matrix for 
other image direction.}
}
\value{
The optimal \eqn{\alpha_v} (or \eqn{\alpha_w}, respectively), found by optimizing the GCV criterion 
  within the given range of possible values.
}
\description{
These functions find the optimal smoothing parameters \eqn{\alpha_v,
\alpha_w} for the two image directions (v and w) in the FCP_TPA algorithm
based on generalized cross-validation, which is nested in the tensor power
algorithm. Given a range of possible values of \eqn{\alpha_v} (or
\eqn{\alpha_w}, respectively), the optimum is found by optimizing the GCV
criterion using the function \code{\link[stats]{optimize}}.
}
\section{Functions}{
\itemize{
\item \code{findAlphaWopt}: 
}}
\references{
G. I. Allen (2013), "Multi-way Functional Principal Components 
  Analysis", IEEE International Workshop on Computational Advances in 
  Multi-Sensor Adaptive Processing.

J. Z. Huang, H. Shen and A. Buja (2009), "The Analysis of Two-Way
  Functional Data Using Two-Way Regularized Singular Value Decomposition". 
  Journal of the American Statistical Association, Vol. 104, No. 488, 1609 --
  1620.
}
\seealso{
\code{\link{FCP_TPA}}, \code{\link{gcv}}
}
\keyword{internal}

