% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFT.variance.R
\name{MFT.variance}
\alias{MFT.variance}
\title{MFT.variance}
\usage{
MFT.variance(Phi, rcp = NULL, autoset.d_H = TRUE, S = NULL, E = NULL,
  d = NULL, H = NULL, alpha = 0.05, sim = 10000,
  method = "asymptotic", Q = NA, perform.CPD = TRUE, plot.CPD = TRUE,
  plot.var = TRUE, print.output = TRUE, col = NULL,
  ylab1 = expression(abs(G[list(h, t)])),
  ylab2 = expression(widehat(sigma)^2), cex.legend = 1.2,
  cex.diamonds = 1.4, wid = NULL, main = TRUE, plot.Q = TRUE,
  plot.M = TRUE, plot.h = TRUE)
}
\arguments{
\item{Phi}{numeric vector of increasing events, input point process}

\item{rcp}{vector, rate CPs of Phi (if MFT for the rates is used: as CP[,1]), default: constant rate}

\item{autoset.d_H}{logical, automatic choice of window size H and step size d}

\item{S}{numeric, start of time interval, default: Smallest multiple of d that lies beyond min(Phi)}

\item{E}{numeric, end of time interval, default: Smallest multiple of d that lies beyond max(Phi), needs E > S.}

\item{d}{numeric, > 0, step size delta at which processes are evaluated. d is automatically set if autoset.d_H = TRUE}

\item{H}{vector, window set H, all elements must be increasing ordered multiples of d, the smallest element must be >= d and the largest =< (T/2). H is automatically set if autoset.d_H = TRUE}

\item{alpha}{numeric, in (0,1), significance level}

\item{sim}{integer, > 0, No of simulations of limit process (for approximation of Q), default = 10000}

\item{method}{either "asymptotic", or "fixed", defines how threshold Q is derived, default: "asymptotic". If "asymptotic": Q is derived by simulation of limit process L (Brownian motion); possible set number of simulations (sim). If "fixed": Q may be set automatically (Q)}

\item{Q}{numeric, rejection threshold, default: Q is simulated according to sim and alpha.}

\item{perform.CPD}{logical, if TRUE change point detection algorithm is performed}

\item{plot.CPD}{logical, if TRUE CPD-scenario is plotted. Only active if perform.CPD == TRUE}

\item{plot.var}{logical, should the variance histogram be plotted? Only possible, if plot.CPD=TRUE}

\item{print.output}{logical, if TRUE results are printed to the console}

\item{col}{"gray" or vector of colors of length(H). Colors for (R_ht) plot, default: NULL -> rainbow colors from blue to red.}

\item{ylab1}{character, ylab for 1. graphic}

\item{ylab2}{character, ylab for 2. graphic}

\item{cex.legend}{numeric, size of annotations in plot}

\item{cex.diamonds}{numeric, size of diamonds that indicate change points}

\item{wid}{integer,>0, width of bars in variance histogram}

\item{main}{logical, indicates if title and subtitle are plotted}

\item{plot.Q}{logical, indicates if rejection threshold Q is plotted}

\item{plot.M}{logical, indicates if test statistic M is plotted}

\item{plot.h}{logical, indicates if a legend for the window set H is plotted}
}
\value{
invisible
\item{M}{test statistic}
\item{varQ}{rejection threshold}
\item{sim}{number of simulations of the limit process (approximation of Q)}
\item{CP}{set of change points estmated by the multiple filter algorithm, increasingly ordered in time}
\item{var}{estimated variances between adjacent change points}
\item{S}{start of time interval}
\item{E}{end of time interval}
\item{H}{window set}
\item{d}{step size delta at which processes were evaluated}
\item{alpha}{significance level}
}
\description{
The multiple filter test for variance change detection in point processes on the line.
}
\examples{
# Rate and variance change detection in Gamma process 
# (rate CPs at t=30 and 37.5, variance CPs at t=37.5 and 52.5) 
set.seed(51)
mu <- 0.03; sigma <- 0.01
p1 <- mu^2/sigma^2; lambda1 <- mu/sigma^2
p2 <- (mu*0.5)^2/sigma^2; lambda2 <- (mu*0.5)/sigma^2
p3 <- mu^2/(sigma*1.5)^2; lambda3 <- mu/(sigma*1.5)^2
p4 <- mu^2/(sigma*0.5)^2; lambda4 <- mu/(sigma*0.5)^2
Phi<- cumsum(c(rgamma(1000,p1,lambda1),rgamma(500,p2,lambda2),
rgamma(500,p3,lambda3),rgamma(300,p4,lambda4)))
# rcp  <- MFT.rate(Phi)$CP[,1] # MFT for the rates
rcp <- c(30,37.5) # but here we assume known rate CPs
MFT.variance(Phi,rcp=rcp) # MFT for the variances

}
\references{
Stefan Albert, Michael Messer, Julia Schiemann, Jochen Roeper and Gaby Schneider (2017) 
Multi-scale detection of variance changes in renewal processes in the presence of rate change points.
Journal of Time Series Analysis, <doi:10.1111/jtsa.12254>
}
\seealso{
\code{\link{MFT.rate}, \link{MFT.mean}}
}
\author{
Michael Messer, Stefan Albert, Solveig Plomer and Gaby Schneider
}
