% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary-plot.R
\name{summarize_eggs_geno}
\alias{summarize_eggs_geno}
\title{Summarize Eggs by Genotype}
\usage{
summarize_eggs_geno(out, spn_P)
}
\arguments{
\item{out}{the output of \code{\link[MGDrivE2]{sim_trajectory_R}}}

\item{spn_P}{the places of the SPN, see details}
}
\value{
a 3 to 5 column dataframe for plotting with ggplot2
}
\description{
This function summarizes egg stage by genotype. It calls
\code{\link{base_aquatic_geno}} to do all of the work.
}
\details{
The places (\code{spn_P}) object is generated from one of the following:
\code{\link{spn_P_lifecycle_node}}, \code{\link{spn_P_lifecycle_network}},
\code{\link{spn_P_epiSIS_node}}, \code{\link{spn_P_epiSIS_network}},
\code{\link{spn_P_epiSEIR_node}}, or \code{\link{spn_P_epiSEIR_network}}.

The return object depends on the data provided. If the simulation was only 1 node,
then no \code{node} designation is returned. If only one repetition was performed,
no \code{rep} designation is returned. Columns always returned include: \code{time},
\code{genotype}, and \code{value}.

For examples of using this function, see:
\code{vignette("lifecycle-node", package = "MGDrivE2")}
}
