% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bAIC.MGLM.R
\docType{methods}
\name{BIC}
\alias{BIC}
\alias{BIC,MGLMfit-method}
\alias{BIC,MGLMreg-method}
\alias{BIC,MGLMsparsereg-method}
\alias{BIC,MGLMtune-method}
\title{Bayesian information criterion (BIC)}
\usage{
\S4method{BIC}{MGLMfit}(object)

\S4method{BIC}{MGLMreg}(object)

\S4method{BIC}{MGLMsparsereg}(object)

\S4method{BIC}{MGLMtune}(object)
}
\arguments{
\item{object}{MGLM object. \code{"MGLMfit"}, \code{"MGLMreg"},
\code{"MGLMsparsereg"}, or \code{"MGLMtune"}}
}
\value{
Returns a numeric value with the corresponding BIC.

For the class \code{"MGLMtune"}, the function returns BIC 
based on the optimal tuning parameter.
}
\description{
Calculates the Bayesian information criterion (BIC) for a fitted model object.
}
\examples{
set.seed(124)
n <- 200
d <- 4
alpha <- rep(1, d-1)
beta <- rep(1, d-1)
m <- 50
Y <- rgdirmn(n, m, alpha, beta)
gdmFit <- MGLMfit(Y, dist="GDM")
BIC(gdmFit)
}
