% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGLMgen.R, R/pdfln.R
\name{rgdirmn}
\alias{rgdirmn}
\alias{gdirmn}
\alias{dgdirmn}
\title{The Generalized Dirichlet Multinomial Distribution}
\usage{
rgdirmn(n, size, alpha, beta)

dgdirmn(Y, alpha, beta)
}
\arguments{
\item{n}{the number of random vectors to generate.  When \code{size} is a scalar and \code{alpha} is a vector, 
must specify \code{n}.  When \code{size} is a vector and \code{alpha} is a matrix, \code{n} is optional.
The default value of \code{n} is the length of \code{size}. If given, \code{n} should be equal to 
the length of \code{size}.}

\item{size}{a number or vector specifying the total number of objects that are put
into d categories in the generalized Dirichlet multinomial distribution.}

\item{alpha}{the parameter of the generalized Dirichlet multinomial distribution. 
\code{alpha} is a numerical positive vector or matrix. 

For \code{gdirmn}, \code{alpha} should match the size of \code{Y}. If \code{alpha} 
is a vector, it will be replicated \eqn{n} times to match the dimension of \code{Y}. 

For \code{rdirmn}, if \code{alpha} is a vector, \code{size} must be a scalar.  All the random vectors will
be drawn from the same \code{alpha} and \code{size}.  If \code{alpha} is a matrix, the 
number of rows should match the length of \code{size}.  Each random vector 
will be drawn from the corresponding row of \code{alpha} and the corresponding element of \code{size}.}

\item{beta}{the parameter of the generalized Dirichlet multinomial distribution. \code{beta} should
have the same dimension as \code{alpha}.

For \code{rdirm}, if \code{beta} is a vector, \code{size} must be a scalar.  All the random samples will
be drawn from the same \code{beta} and \code{size}.  If \code{beta} is a matrix, the 
number of rows should match the length of \code{size}.  Each random vector 
will be drawn from the corresponding row of \code{beta} and the corresponding element of \code{size}.}

\item{Y}{the multivariate count matrix with dimensions \eqn{n \times d}{nxd}, where 
\eqn{n = 1,2, \ldots} is the number of observations and \eqn{d=3,4,\ldots} is the number of categories.}
}
\value{
\code{dgdirmn} returns the value of 
\eqn{\log(P(y|\alpha, \beta))}{logP(y|\alpha, \beta)}. 
When \code{Y} is a matrix of \eqn{n} rows, the function \code{dgdirmn} returns a vector of length \eqn{n}. 

\code{rgdirmn} returns a \eqn{n\times d}{nxd} matrix of the generated random observations.
}
\description{
\code{rgdirmn} generates random observations from the generalized Dirichlet multinomial distribution. 
\code{dgdirmn} computes the log of the generalized Dirichlet multinomial probability mass function.
}
\details{
\eqn{Y=(y_1, \ldots, y_d)} are the \eqn{d} category count vectors. Given the parameter vector \eqn{\alpha = (\alpha_1, \ldots, \alpha_{d-1}),
\alpha_j>0}, and \eqn{\beta=(\beta_1, \ldots, \beta_{d-1}), \beta_j>0},
the generalized Dirichlet multinomial probability mass function is 
\deqn{
  P(y|\alpha,\beta)
  =C_{y_1, \ldots, y_d}^{m} \prod_{j=1}^{d-1} 
  \frac{\Gamma(\alpha_j+y_j)}{\Gamma(\alpha_j)}
  \frac{\Gamma(\beta_j+z_{j+1})}{\Gamma(\beta_j)}
  \frac{\Gamma(\alpha_j+\beta_j)}{\Gamma(\alpha_j+\beta_j+z_j)}  ,
}{
  P(y|\alpha,\beta)
  =C_{y_1, \ldots, y_d}^{m} prod_{j=1}^{d-1} {Gamma(\alpha_j+y_j)Gamma(\beta_j+z_{j+1})Gamma(\alpha_j+\beta_j)} / {Gamma(\alpha_j)Gamma(\beta_j)Gamma(\alpha_j+\beta_j+z_j)},
}
where \eqn{z_j = \sum_{k=j}^d y_k}{z_j = sum_{k=j}^d y_k} and \eqn{m = \sum_{j=1}^d y_j}{m = sum_{j=1}^d y_j}.
Here, \eqn{C_k^n}, often read as "\eqn{n} choose \eqn{k}", 
refers the number of \eqn{k} combinations from a set of \eqn{n} elements.

The \eqn{\alpha} and \eqn{\beta} parameters can be vectors, like the results from the 
distribution
fitting function, or they can be matrices with \eqn{n} rows, 
like the estimate
from the regression function multiplied by the covariate matrix
\eqn{exp(X\alpha)} and \eqn{exp(X\beta)}
}
\examples{
# example 1
m <- 20
alpha <- c(0.2, 0.5)
beta <- c(0.7, 0.4)
Y <- rgdirmn(10, m, alpha, beta)
dgdirmn(Y, alpha, beta)

# example 2 
set.seed(100)
alpha <- matrix(abs(rnorm(40)), 10, 4)
beta <- matrix(abs(rnorm(40)), 10, 4)
size <- rbinom(10, 10, 0.5)
GDM.rdm <- rgdirmn(size=size, alpha=alpha, beta=beta)
GDM.rdm1 <- rgdirmn(n=20, size=10, alpha=abs(rnorm(4)), beta=abs(rnorm(4)))
}
\keyword{distribution}
\keyword{models}
