% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_Mix_MVN.R
\name{fit.mix}
\alias{fit.mix}
\title{Fit Multivariate Mixture Distribution}
\usage{
fit.mix(
  data,
  k = 2,
  init_means = NULL,
  fix_means = FALSE,
  init_covs = NULL,
  init_props = NULL,
  maxit = 100,
  eps = 1e-06,
  report = FALSE
)
}
\arguments{
\item{data}{Numeric data matrix.}

\item{k}{Number of mixture components. Defaults to 2.}

\item{init_means}{Optional list of initial mean vectors.}

\item{fix_means}{Fix means to their starting values? Must initialize.}

\item{init_covs}{Optional list of initial covariance matrices.}

\item{init_props}{Optional vector of initial cluster proportions.}

\item{maxit}{Maximum number of EM iterations.}

\item{eps}{Minimum acceptable increment in the EM objective.}

\item{report}{Report fitting progress?}
}
\value{
Object of class \code{mix} containing the estimated
}
\description{
Given a matrix of random vectors, estimates the parameters for a mixture of
multivariate normal distributions. Accommodates arbitrary patterns of
missingness, provided the elements are missing at random (MAR).
}
