% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcPdist_func_20171023.R
\name{CalcPdist}
\alias{CalcPdist}
\title{CalcPdist() function}
\usage{
CalcPdist(seq_file, path_out, aa_pdist = NULL, codon_pos = NULL,
  input_fasta = NULL)
}
\arguments{
\item{seq_file}{seq_file is a sequence table as output by the 'dada2'
pipeline, which has samples in rows and nucleotide sequence variants in
columns. Optionally, a fasta file can be supplied as input in the format
rendered by e.g. read.fasta() from the package 'seqinr'.}

\item{path_out}{is a user defined path to the folder where the output files
will be saved.}

\item{aa_pdist}{optional, a logical (TRUE/FALSE) that determines whether
nucleotide sequences should be translated to amino acid sequences before
p-distance calculation, default is NULL/FALSE.}

\item{codon_pos}{optional, a vector of codon positions to include in
p-distance calculations, if this argument is omitted, p-distance
calculations are made using all codons.}

\item{input_fasta}{optional, a logical (TRUE/FALSE) that indicates whether
the input file is a fasta file (TRUE) or a dada2 sequence table
(NULL/FALSE), default is NULL/FALSE.}
}
\value{
The function returns a matrix with p-distances of all pairwise
  sequence comparisons. This table is saved as a .csv file in the output path.
  If a fasta file is used as input, only the p-distance matrix will be
  produced. If a sequence table is given as input file, the function
  additionally returns a table with the mean p-distance for each sample. If a
  sequence table is given as input file, the sequences are named in the
  output matrix by an index number corresponding to their column number in
  the sequence table.
}
\description{
\code{\link{CalcPdist}} calculates p-distances from pairwise sequence
comparisons and mean p-distances for each sample in a 'dada2' sequence
table.
}
\examples{
seq_file <- sequence_table_fas
path_out <- tempdir()
CalcPdist(seq_file, path_out, aa_pdist=NULL, codon_pos=c(1,2,3,4,5,6,7,8), input_fasta=NULL)
}
\seealso{
For more information about 'dada2'visit
  <https://benjjneb.github.io/dada2>
}
