% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_microbiology_events.R
\name{cleanse_urine_organism_names}
\alias{cleanse_urine_organism_names}
\title{Cleanse organism names in Urine samples}
\usage{
cleanse_urine_organism_names(
  data,
  column_name = "org_name",
  strings_to_remove = NULL,
  standard_mapping = NULL,
  filter_values = NULL
)
}
\arguments{
\item{data}{The dataframe containing urine sample data.}

\item{column_name}{The name of the column containing organism names.}

\item{strings_to_remove}{A character vector of strings to be removed from the organism names.}

\item{standard_mapping}{A named character vector specifying mappings of values to standard ones.}

\item{filter_values}{A character vector of values to be filtered out from the organism names.}
}
\value{
The preprocessed dataframe.
}
\description{
Function to preprocess organism names in urine samples.
Removes specified strings, maps certain values to standard ones, and filters out unwanted values.
}
\examples{
data <- data.frame(org_name = c("PRESUMPTIVELY Streptococcus",
              "MODERATE Escherichia coli",
              "S. AUREUS POSITIVE",
              "CANCELLED Influenza A"))
data <- cleanse_urine_organism_names(data,
                                   column_name = "org_name",
                                   strings_to_remove = c("POSITIVE FOR",
                                                        "PRESUMPTIVELY","PRESUMPTIVE",
                                                        "PROBABLE", "IDENTIFICATION",
                                                        "RESEMBLING", "SEEN",
                                                        "MODERATE", "FEW", "BETA",
                                                         "METHICILLIN RESISTANT",
                                                         "NUTRITIONALLY VARIANT",
                                                         "NOT C. PERFRINGENS OR C. SEPTICUM",
                                                        "-LACTAMASE POSITIVE",
                                                        "-LACTAMASE NEGATIVE",
                                                         "VIRAL ANTIGEN",
                                                         "CANDIDA INCONSPICUA",
                                                        "/POSADASII",
                                                        "NOT FUMIGATUS, FLAVUS OR NIGER",
                                                        "MRSA POSITIVE", "MRSA NEGATIVE",
                                                        "HISTOLYTICA/DISPAR"),
                                   standard_mapping = c(
                                                        "NON-FERMENTER" = "STREPTOCOCCUS",
                                                        "ABIOTROPHIA/GRANULICATELLA" =
                                                                            "STREPTOCOCCUS",
                                                        "S. AUREUS POSITIVE" =
                                                                           "STAPHYLOCOCCUS AUREUS",
                                                        "ASPERGILLUS FUMIGATUS COMPLEX" =
                                                                           "ASPERGILLUS FUMIGATUS",
                                                        "(CRYPTOSPORIDIUM PARVUM OOCYSTS|
                                                        CUNNINGHAMELLA BERTHOLLETIAE|
                                                        EPIDERMOPHYTON FLOCCOSUM|
                                                        EXOPHIALA JEANSELMEI COMPLEX|
                                                        SCEDOSPORIUM|
                                                        NEOASCOCHYTA DESMAZIERI|
                                                        NEOSCYTALIDIUM DIMIDIATUM|
                                                        LOMENTOSPORA|NEUROSPORA|
                                                        PERONEUTYPA SCOPARIA|
                                                        SPOROTHRIX SCHENCKII COMPLEX|
                                                        ZYGOSACCHAROMYCES FERMENTATI)" =
                                                                            "UNKNOWN FUNGUS"
                                                        ),
                                   filter_values = c('CANCELLED|VIRUS|SIMPLEX|PARAINFLUENZA|
                                                     INFLUENZA A|INFLUENZA B|TICK|
                                                     AFB GROWN|GRAM VARIABLE RODS|HYMENOLEPIS'))

}
