% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalm.R
\name{LL}
\alias{LL}
\title{LL: Log-likelihood function}
\usage{
LL(preds, positive = colnames(preds)[2])
}
\arguments{
\item{preds}{Data frame: Data frame of probabilities and ground truth labels.}

\item{positive}{Character vector: The name of the positive group, must equal a column name consisting of probabilities.}
}
\value{
Log-likelihood
}
\description{
Calculates the Log-likelihood to evaluate probabilities. A data frame of probabilities and ground truth labels must
be passed in to evaluate. Raw probability data must be column1: prob G1, column2: prob G2,
column3: obs labels, column4: Group (optional). Zero is optimal and more negative is less.
}
\examples{
r1 <- LL(preds)
}
