% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorize_data.R
\name{factorize_numeric_vector}
\alias{factorize_numeric_vector}
\title{Turn numeric vector into an ordered factor}
\usage{
factorize_numeric_vector(
  data_vector,
  method = c("equal_bins", "equal_distance", "custom_breaks"),
  breaks_no = 5,
  custom_breaks = NULL,
  custom_labels = NULL
)
}
\arguments{
\item{data_vector}{Numeric vector.}

\item{method}{Factorization rule: one of \code{"equal_bins"}, \code{"equal_distance"}, \code{"custom_breaks"}.}

\item{breaks_no}{Integer \eqn{\ge 2}; number of intervals when \code{method != "custom_breaks"}.}

\item{custom_breaks}{Optional numeric vector of cut points (strictly increasing) used when \code{method = "custom_breaks"}.}

\item{custom_labels}{Optional character vector of labels. If supplied, its length should equal \code{length(custom_breaks) - 1}.}
}
\value{
An ordered factor with interval labels.
}
\description{
Turn numeric vector into an ordered factor
}
\examples{
factorize_numeric_vector(runif(10))
}
