% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FinMix.R
\name{FinMix}
\alias{FinMix}
\title{Finite k components and multiple m trials}
\usage{
FinMix(data, k, T = 2000)
}
\arguments{
\item{data}{- an array with dimension c(n,p,d). data[i,j,c] denotes the number of trials occurs in i-th observation, j-th variable and c-th categories.}

\item{k}{- number of components is known}

\item{T}{- number of iterations in Gibbs sampler, default value is 2000. T should be an even number for 'burn-in'. The estimates are computed by the second-half iterations.}
}
\value{
theta - a vector that sum to 1, denotes probability of latent class.

psi - an array with dimension c(k,p,d), specific probability for each variables in each component.
}
\description{
This function is applied when number of components k is known and number of trials m > 2k -1. Missing data is allowed in dataset.
This function estimates parameters of latent joint distribution which observations are generated from.
}
\note{
m - number of trials, i.e., m = sum(data[i,j,]). Here m are identical for all i and j.
m > 2k - 1 is a condition that guarantees identifiability (Elmore and Wang, 2003).

n - number of observations

p - number of variables

d - number of categories. Here d are identical for all variables.

r - matrix with n rows and p columns. If data[i,j,] is missing, r[i,j] = 0. Otherwise r[i,j] = 1. data[i,j,] must be missing or observed for all trials.

q - matrix with k rows and p columns, denotes missing probability for each variable in different components.
}
\examples{
k <- 2
## IncompleteData example
data("IncompleteData")
FinMix(data = IncompleteData$data,k)
}
\references{
[1] Elmore, Ryan, and Shaoli Wang. "ldentifiability and Estimation in Finite Mixture Models with Multinomial Components."
}

