% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNB.R
\docType{data}
\name{alzheimer}
\alias{alzheimer}
\title{Alzheimer data}
\format{
This data frame contains the following columns:
\itemize{
\item Y: The number of words that the patients could recalled from lists of words.
\item trt: Placebo ano lecithin groups.
\item ind: Indicator on the ith patient.
\item time:  initially, 1st, 2nd, 4th and 6th visit.
}
}
\usage{
data(alzheimer)
}
\description{
The Alzheimer’s data is presented in Hand and Taylor (1987) and Hand and
Crowder (1996) to assess deterioration aspects of intellect, self-care and
personality in senile patients with Alzheimer’s disease. Two groups of patients
were compared, one of which received a placebo and the other treatment with
lecithin. In the data, each of the subjects, 26 in the placebo group and 22
in the lecithin group, were measured on five occasions (initially, 1st, 2nd, 4th and 6th).
The measurements were the number of words that the patients could recalled from lists of words.
}
\examples{

data(alzheimer)
head(alzheimer)

}
\references{
\itemize{
\item Hand, D. J. and Crowder, M. (1996). Practical Longitudinal Data Analysis. London: Chapman and Hall.
\item Hand, D. J. and Taylor, C. C. (1987). Analysis of Variance and Repeated Measures. London: Chapman and Hall.
\item Fabio, L. C., Villegas, C., Carrasco, J. M. F., and de Castro, M. (2021). D
Diagnostic tools for a multivariate negative binomial model for fitting correlated data with
overdispersion. Communications in Statistics - Theory and Methods.
https://doi.org/10.1080/03610926.2021.1939380.
\item Residual analysis for discrete correlated data in the multivariate approach. Submitted.
}
}
\keyword{dataSets}
