% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotConsensus.R
\name{plotConsensus}
\alias{plotConsensus}
\title{\code{plotConsensus}}
\usage{
plotConsensus(
  tileObject,
  cellPopulations = "All",
  groupColumn = NULL,
  returnPlotList = FALSE,
  returnDFs = FALSE,
  numCores = 1
)
}
\arguments{
\item{tileObject}{A MultiAssayExperiment object from callOpenTiles,}

\item{cellPopulations}{the cell populations you want to visualize.}

\item{groupColumn}{Optional parameter, same as in getSampleTileMatrix, which defines whether you
want to plot reproducibility within each}

\item{returnPlotList}{Instead of one plot with all celltypes/conditions, it returns a list of plots for each cell types}

\item{returnDFs}{Instead of a plot, returns a data.frame of the reproducibility across samples.
If set to false, then it plots the data.frame instead of returning it.}

\item{numCores}{Number of cores to multithread over.}
}
\value{
SampleTileObj the input data structure with added gene annotations.
}
\description{
\code{plotConsensus} Extracts the peak reproducibility and generates a
					heuristic plots that can be used to determine the reproducibility threshold
					used within getSampleTileMatrix.
}
