% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packMOCHA.R
\name{packMOCHA}
\alias{packMOCHA}
\title{\code{packMOCHA}}
\usage{
packMOCHA(MOCHAObj, zipfile, verbose = FALSE)
}
\arguments{
\item{MOCHAObj}{A MultiAssayExperiment or RangedSummarizedExperiment, from
MOCHA}

\item{zipfile}{Filename and path of the zip archive.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
zipfile Path to zip archive.
}
\description{
\code{packMOCHA} combines a MOCHA object (Sample-Tile
  Matrix or tileResults) with its saved coverage tracks into a single zip
  archive. This allows MOCHA objects and the necessary coverage files for
  plotting to be shared to other file systems. See also:
  \link[MOCHA]{unpackMOCHA}
}
\examples{
\dontrun{
# Depends on and manipulates files on filesystem
myOutputDir <- "/home/documents/MOCHA_out"
zipPath <- MOCHA::packMOCHA(
  tileResults, zipfile = file.path(myOutputDir, "testzip.zip")
)
}

}
