% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporalComposite.R
\name{temporalComposite}
\alias{temporalComposite}
\title{Calculate MODIS Composite Images}
\usage{
temporalComposite(x, y, interval = c("month", "fortnight"),
  fun = function(x) max(x, na.rm = TRUE), cores = 1L, filename = "", ...)
}
\arguments{
\item{x}{\code{Raster*} or \code{character}. MODIS vegetation index.}

\item{y}{\code{Raster*} or \code{character}. MODIS
"composite_day_of_the_year" SDS associated with 'x'.}

\item{interval}{\code{character}. Time period for aggregation, see
\code{\link{aggInterval}}.}

\item{fun}{\code{function}. See \code{\link{overlay}}.}

\item{cores}{\code{integer}. Number of cores for parallel processing.}

\item{filename}{\code{character}. Optional output filename.}

\item{...}{Additional arguments passed to \code{\link{writeRaster}}.}
}
\value{
A \code{Raster*} object.
}
\description{
Based on a user-defined function, e.g. \code{max} for maximum value
composites (MVC), aggregate native 16-day MODIS datasets to custom temporal
composites.
}
\examples{
\dontrun{
runGdal("MOD13Q1", collection = getCollection("MOD13Q1", forceCheck = TRUE),
        begin = "2015001", end = "2015365", extent = "Luxembourg",
        job = "temporalComposite", SDSstring = "100000000010")

ndvi <- list.files(paste0(getOption("MODIS_outDirPath"), "/temporalComposite"),
                   pattern = "NDVI.tif", full.names = TRUE)

cdoy <- list.files(paste0(getOption("MODIS_outDirPath"), "/temporalComposite"),
                   pattern = "day_of_the_year.tif", full.names = TRUE)

mmvc <- temporalComposite(ndvi, cdoy)
plot(mmvc[[1:4]])
}

}
\author{
Florian Detsch
}
\seealso{
\code{\link{aggInterval}}, \code{\link{overlay}},
\code{\link{writeRaster}}.
}

