% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-classes.R
\name{MODISfile-class}
\alias{MODISfile-class}
\title{Class MODISfile}
\description{
An object of class \code{MODISfile}, typically created through 
\code{\link[MODIS]{getProduct}} when the 'x' input is a MODIS filename.
}
\section{Slots}{

\describe{
\item{\code{request}}{User request as \code{character}.}

\item{\code{PRODUCT}}{MODIS product identified from 'request' as \code{character}.}

\item{\code{DATE}}{Acquisition date string in the form \code{"A\%Y\%j"} (see 
\code{\link{strptime}} and 
\href{https://modis-images.gsfc.nasa.gov/MOD07_L2/filename.html}{HDF filename convention}).}

\item{\code{TILE}}{Tile string in the form \code{"hXXvXX"}.}

\item{\code{CCC}}{MODIS data collection as 3-digit \code{character}.}

\item{\code{PROCESSINGDATE}}{Processing date string in the form \code{"\%Y\%j\%H\%M\%S"} 
(see \code{\link{strptime}}).}

\item{\code{FORMAT}}{File format as \code{character}.}

\item{\code{SENSOR}}{Statically set to \code{"MODIS"}.}

\item{\code{PLATFORM}}{Satellite platform on which MODIS sensor is mounted; one of 
\code{c("Terra", "Aqua")}.}

\item{\code{PF1,PF2,PF3,PF4}}{Platform specific path feature for LP DAAC, LAADS, NTSG 
and NSIDC as \code{character}.}

\item{\code{TOPIC}}{Product topic as \code{character}.}

\item{\code{TYPE}}{Product type; one of \code{c("Tile", "CMG", "Swath")}.}

\item{\code{SOURCE}}{Product specific MODIS download server(s) as named \code{list}.}

\item{\code{POS1,POS2}}{Default start and end index of date string in MODIS filename, 
usually \code{c("10", "16")}.}
}}

