% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODISoptions.R
\name{MODISoptions}
\alias{MODISoptions}
\title{Set or Retrieve Permanent MODIS Package Options}
\usage{
MODISoptions(
  localArcPath,
  outDirPath,
  pixelSize,
  outProj,
  resamplingType,
  dataFormat,
  gdalPath,
  MODISserverOrder,
  dlmethod,
  stubbornness,
  wait,
  quiet,
  cellchunk,
  systemwide = FALSE,
  save = TRUE,
  checkTools = TRUE,
  checkWriteDrivers = TRUE,
  ask = TRUE,
  check_earthdata_login = TRUE
)
}
\arguments{
\item{localArcPath}{\code{character}, defaults to
\code{file.path(tempdir(), "MODIS_ARC")}. Target folder for downloaded MODIS HDF
files.}

\item{outDirPath}{\code{character}, defaults to
\code{file.path(tempdir(), "MODIS_ARC/PROCESSED")}. Target folder for results
of \code{\link[=runGdal]{runGdal()}} and \code{\link[=runMrt]{runMrt()}}.}

\item{pixelSize}{Output pixel size (in target reference system units) passed
to \code{\link[=runGdal]{runGdal()}} and \code{\link[=runMrt]{runMrt()}}, defaults to \code{"asIn"}.}

\item{outProj}{Target reference system passed to \code{\link[=runGdal]{runGdal()}} and
\code{\link[=runMrt]{runMrt()}}. \code{\link[=runGdal]{runGdal()}} requires a valid CRS. As for \code{\link[=runMrt]{runMrt()}}, please
consult the MRT manual. Since the two processing methods do not have common
methods, it is suggested to stick with the default settings (see Details).}

\item{resamplingType}{Defaults to \code{"NN"} (Nearest Neighbor). MRT and GDAL
both support \code{c('NN', 'CC', 'BIL')}. GDAL additionally supports all
resampling methods listed under \url{https://gdal.org/programs/gdalwarp.html}.}

\item{dataFormat}{\code{character}, defaults to \code{"GTiff"}. See
\code{sf::st_drivers(what = "raster")} for available options.}

\item{gdalPath}{\code{character}. Path to GDAL binary executable, used to relate
writable \code{sf::st_drivers("raster")} to file extensions in case of
non-standard formats.}

\item{MODISserverOrder}{\code{character}. Possible options are \code{"LPDAAC"}
(default), \code{"LAADS"} (see 'dlmethod' and Details). If only one server is
selected, all efforts to download data from the second server are
inhibited.}

\item{dlmethod}{\code{character}, defaults to \code{"auto"}. See 'method' in
\code{\link[utils:download.file]{utils::download.file()}} for available options. If installed, you can also
leverage \code{"aria2"} for multi-source download. Note that in any case, either
curl or wget must be installed and made available through the system's PATH
environment variable to validate Earthdata Login credentials.}

\item{stubbornness}{\code{numeric}. The number of retries after the target server
has refused a connection. Higher values increase the chance of getting the
file, but also lead to hanging functions if the server is down.}

\item{wait}{\code{numeric} waiting time (in seconds) inserted after each internal
online download call via \code{\link[utils:download.file]{utils::download.file()}} or \code{\link[curl:curl]{curl::curl()}}.
Reduces the chance of connection errors that may occur after many requests.}

\item{quiet}{\code{logical} passed e.g. to \code{\link[utils:download.file]{utils::download.file()}} and
\code{\link[sf:gdal_utils]{sf::gdal_utils()}}.}

\item{cellchunk}{Default \code{1}, i.e. use raster default. Comparable with
'chunksize' in \code{\link[raster:rasterOptions]{raster::rasterOptions()}}, but as no effect was found in
adapting chunksize, \strong{MODIS} applies its own variant. On a reasonable
working station, 'cellchunk' can easily be increased to \code{5e5}.}

\item{systemwide}{A \code{logical} determining whether changes made to
\code{\link[=MODISoptions]{MODISoptions()}} are to be applied system-wide or per user (default), see
Details.}

\item{save}{\code{logical}. If \code{TRUE} (default), settings are permanent.}

\item{checkTools}{\code{logical}, defaults to \code{TRUE}. Check if external tools
(i.e., GDAL and MRT) are installed and reachable through R.}

\item{checkWriteDrivers}{\code{logical}. If \code{TRUE} (default), find write drivers
supported by \strong{sf} GDAL installation.}

\item{ask}{\code{logical}. If \code{TRUE} (default) and permanent settings file does
not exist (see Details), the user is asked whether to create it.}

\item{check_earthdata_login}{\code{logical}. If \code{TRUE} (default), look for
Earthdata Login credentials in \verb{~/.netrc} and try to download a small
sample \code{.hdf} file.}
}
\value{
An invisible \code{list} of \strong{MODIS} options. In addition, the most relevant of
these options are printed to the console. Use \code{\link[utils:capture.output]{utils::capture.output()}} to
prevent this behavior.
}
\description{
Set or retrieve \strong{MODIS} package options (per user or system-wide). If
\code{save = TRUE} (default), changes will persist through sessions and updates.
}
\details{
These settings are easy to change and take effect immediately! However,
please mind that the
\href{https://cran.r-project.org/web/packages/policies.html}{CRAN Repository Policy}
does not permit automated write access to the user's file system exempt for
\code{\link[=tempdir]{tempdir()}}. Therefore, changes made to \code{\link[=MODISoptions]{MODISoptions()}} remain temporary for
the current session unless write access is explicitly granted by the user in
interactive mode, in which case a permanent settings file is created in
\code{file.path("~/.MODIS_Opts.R")} (per user) or
\code{file.path(R.home(component = "etc"), '.MODIS_Opts.R')} (system-wide, write
access provided).

Due to similar reasons, 'localArcPath' and 'outDirPath' default to
\code{\link[=tempdir]{tempdir()}} and should be changed immediately after loading the package in
order to make downloaded files permanently available. You may also specify a
shared network drive if you have a central MODIS data server.

If you change default values, consider that your settings have to be valid
for any MODIS product, layer and area!

Please note that in order to download MODIS files from any available server,
you are required to
\itemize{
\item register for an Earthdata Login profile at
\url{https://urs.earthdata.nasa.gov/users/new},
\item fill out mandatory fields therein, and
\item create a \code{.netrc} file in your home directory containing the Earthdata
server address and your login credentials. An automated solution for the
creation of such a file is provided through \code{\link[=EarthdataLogin]{EarthdataLogin()}}.
}
}
\examples{
\dontrun{
## get options
MODISoptions()

## set options
lap = "/another/path/to/MODIS_ARC" # 'localArcPath'
odp = file.path(lap, "PROCESSED")  # 'outDirPath'

MODISoptions(localArcPath = lap, outDirPath = odp)
}

}
\author{
Matteo Mattiuzzi, Steven Mosher and Florian Detsch
}
